/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.builtins;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.daemon.command.polling.CommandParameters;
import com.aspectran.daemon.service.DaemonService;
import java.util.Map;

public class TransletCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "translet";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public TransletCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        DaemonService service = this.getService();
        String transletName = parameters.getTransletName();
        if (transletName == null) {
            return this.failed(this.error("'translet' parameter is not specified"));
        }
        try {
            ItemExpression evaluator = new ItemExpression(service.getDefaultActivity());
            ParameterMap parameterMap = null;
            ItemRuleMap parameterItemRuleMap = parameters.getParameterItemRuleMap();
            if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
                parameterMap = evaluator.evaluateAsParameterMap(parameterItemRuleMap);
            }
            Map attributeMap = null;
            ItemRuleMap attributeItemRuleMap = parameters.getAttributeItemRuleMap();
            if (attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
                attributeMap = evaluator.evaluate(attributeItemRuleMap);
            }
            Translet translet = service.translate(transletName, parameterMap, attributeMap);
            String result = translet.getResponseAdapter().getWriter().toString();
            return this.success(result);
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return TransletCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return TransletCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Executes a translet";
        }
    }
}

