/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.polling;

import com.aspectran.core.context.config.DaemonPollerConfig;
import com.aspectran.daemon.Daemon;
import com.aspectran.daemon.command.polling.CommandExecutor;
import com.aspectran.daemon.command.polling.CommandPoller;

public abstract class AbstractCommandPoller
implements CommandPoller {
    private static final long DEFAULT_POLLING_INTERVAL = 5000L;
    private static final int DEFAULT_MAX_THREADS = Runtime.getRuntime().availableProcessors();
    private final Daemon daemon;
    private CommandExecutor executor;
    private long pollingInterval;
    private int maxThreads;
    private boolean requeue;

    public AbstractCommandPoller(Daemon daemon, DaemonPollerConfig pollerConfig) {
        if (daemon == null) {
            throw new IllegalArgumentException("daemon must not be null");
        }
        this.daemon = daemon;
        this.pollingInterval = pollerConfig.getPollingInterval(5000L);
        this.maxThreads = pollerConfig.getMaxThreads(DEFAULT_MAX_THREADS);
        this.requeue = pollerConfig.isRequeue();
        this.executor = new CommandExecutor(daemon, this.maxThreads);
    }

    @Override
    public Daemon getDaemon() {
        return this.daemon;
    }

    @Override
    public CommandExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void stop() {
        this.executor.shutdown();
    }

    @Override
    public long getPollingInterval() {
        return this.pollingInterval;
    }

    @Override
    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public boolean isRequeue() {
        return this.requeue;
    }
}

