/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.polling;

import com.aspectran.core.context.config.DaemonPollerConfig;
import com.aspectran.core.util.FilenameUtils;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.AponWriter;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.daemon.Daemon;
import com.aspectran.daemon.command.polling.AbstractCommandPoller;
import com.aspectran.daemon.command.polling.CommandExecutor;
import com.aspectran.daemon.command.polling.CommandParameters;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;

public class FileCommandPoller
extends AbstractCommandPoller {
    protected final Log log = LogFactory.getLog(FileCommandPoller.class);
    private static final String DEFAULT_INBOUND_PATH = "/inbound";
    private static final String INBOUND_QUEUED_DIR = "queued";
    private static final String INBOUND_COMPLETED_DIR = "completed";
    private static final String INBOUND_FAILED_DIR = "failed";
    private final Object lock = new Object();
    private final File inboundDir;
    private final File queuedDir;
    private final File completedDir;
    private final File failedDir;

    public FileCommandPoller(Daemon daemon, DaemonPollerConfig pollerConfig) throws Exception {
        super(daemon, pollerConfig);
        try {
            File inboundDir;
            String basePath = this.getDaemon().getService() != null ? this.getDaemon().getService().getBasePath() : null;
            String inboundPath = pollerConfig.getInboundPath(DEFAULT_INBOUND_PATH);
            if (inboundPath.startsWith("file:")) {
                URI uri = URI.create(inboundPath);
                inboundDir = new File(uri);
            } else {
                inboundDir = basePath != null ? new File(basePath, inboundPath) : new File(inboundPath);
            }
            inboundDir.mkdirs();
            this.inboundDir = inboundDir;
            File queuedDir = new File(inboundDir, INBOUND_QUEUED_DIR);
            queuedDir.mkdir();
            this.queuedDir = queuedDir;
            File completedDir = new File(inboundDir, INBOUND_COMPLETED_DIR);
            completedDir.mkdir();
            this.completedDir = completedDir;
            File failedDir = new File(inboundDir, INBOUND_FAILED_DIR);
            failedDir.mkdir();
            this.failedDir = failedDir;
            File[] inboundFiles = this.getCommandFiles(inboundDir);
            if (inboundFiles != null) {
                for (File file : inboundFiles) {
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize daemon command poller", e);
        }
    }

    public File getInboundDir() {
        return this.inboundDir;
    }

    public File getQueuedDir() {
        return this.queuedDir;
    }

    public File getCompletedDir() {
        return this.completedDir;
    }

    public File getFailedDir() {
        return this.failedDir;
    }

    @Override
    public void requeue() {
        block4: {
            File[] queuedFiles = this.getCommandFiles(this.queuedDir);
            if (queuedFiles == null) break block4;
            if (this.isRequeue()) {
                for (File file : queuedFiles) {
                    CommandParameters parameters = this.readCommandFile(file);
                    if (parameters == null) continue;
                    this.writeCommandFile(this.inboundDir, file.getName(), parameters);
                    this.removeCommandFile(this.queuedDir, file.getName());
                }
            } else {
                for (File file : queuedFiles) {
                    this.removeCommandFile(this.queuedDir, file.getName());
                }
            }
        }
    }

    @Override
    public void polling() {
        File[] files = this.getCommandFiles(this.inboundDir);
        if (files != null) {
            int limit = this.getMaxThreads() - this.getExecutor().getQueueSize();
            for (int i = 0; i < files.length && i < limit; ++i) {
                String inboundFileName;
                String queuedFileName;
                File file = files[i];
                CommandParameters parameters = this.readCommandFile(file);
                if (parameters == null || (queuedFileName = this.writeCommandFile(this.queuedDir, inboundFileName = file.getName(), parameters)) == null) continue;
                this.removeCommandFile(this.inboundDir, inboundFileName);
                this.executeQueuedCommand(parameters, queuedFileName);
            }
        }
    }

    private boolean executeQueuedCommand(final CommandParameters parameters, final String queuedFileName) {
        return this.getExecutor().execute(parameters, new CommandExecutor.Callback(){

            @Override
            public void success() {
                FileCommandPoller.this.removeCommandFile(FileCommandPoller.this.queuedDir, queuedFileName);
                FileCommandPoller.this.writeCommandFile(FileCommandPoller.this.completedDir, this.makeFileName(), parameters);
            }

            @Override
            public void failure() {
                FileCommandPoller.this.removeCommandFile(FileCommandPoller.this.queuedDir, queuedFileName);
                FileCommandPoller.this.writeCommandFile(FileCommandPoller.this.failedDir, this.makeFileName(), parameters);
            }

            private String makeFileName() {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssSSS");
                String datetime = formatter.format(LocalDateTime.now());
                return datetime + "_" + queuedFileName;
            }
        });
    }

    private File[] getCommandFiles(File dir) {
        File[] files = dir.listFiles(file -> file.isFile() && file.getName().toLowerCase().endsWith(".apon"));
        if (files != null && files.length > 0) {
            Arrays.sort(files, Comparator.comparing(File::getName));
        }
        return files;
    }

    private CommandParameters readCommandFile(File file) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Read command file: " + file.getAbsolutePath());
        }
        try {
            CommandParameters parameters = new CommandParameters();
            AponReader.parse((File)file, (Parameters)parameters);
            return parameters;
        }
        catch (IOException e) {
            this.log.error("Failed to read command file: " + file.getAbsolutePath(), (Throwable)e);
            this.removeCommandFile(this.inboundDir, file.getName());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeCommandFile(File dir, String fileName, CommandParameters parameters) {
        File file = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                file = FilenameUtils.generateUniqueFile((File)new File(dir, fileName));
                file.createNewFile();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Write command file: " + file.getAbsolutePath());
            }
            AponWriter aponWriter = new AponWriter(file).nullWritable(false);
            aponWriter.write((Parameters)parameters);
            aponWriter.close();
            return file.getName();
        }
        catch (IOException e) {
            if (file != null) {
                this.log.warn("Failed to write command file: " + file.getAbsolutePath(), (Throwable)e);
            } else {
                File f = new File(dir, fileName);
                this.log.warn("Failed to write command file: " + f.getAbsolutePath(), (Throwable)e);
            }
            return null;
        }
    }

    private void removeCommandFile(File dir, String fileName) {
        File file = new File(dir, fileName);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Delete command file: " + file.getAbsolutePath());
        }
        if (!file.delete()) {
            this.log.warn("Failed to delete command file: " + file.getAbsolutePath());
        }
    }
}

