/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.service;

import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionAgent;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.config.DaemonConfig;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.service.AspectranCoreService;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.daemon.adapter.DaemonSessionAdapter;
import com.aspectran.daemon.service.DaemonService;

public abstract class AbstractDaemonService
extends AspectranCoreService
implements DaemonService {
    private SessionManager sessionManager;
    private SessionAgent sessionAgent;

    public AbstractDaemonService() {
        this.determineBasePath();
    }

    @Override
    public boolean isExposable(String transletName) {
        return super.isExposable(transletName);
    }

    @Override
    public SessionAdapter newSessionAdapter() {
        if (this.sessionAgent != null) {
            return new DaemonSessionAdapter(this.sessionAgent);
        }
        return null;
    }

    protected void initSessionManager() {
        SessionManagerConfig sessionManagerConfig;
        DaemonConfig daemonConfig = this.getAspectranConfig().getDaemonConfig();
        if (daemonConfig != null && (sessionManagerConfig = daemonConfig.getSessionManagerConfig()) != null && sessionManagerConfig.isStartup()) {
            try {
                this.sessionManager = DefaultSessionManager.create((ActivityContext)this.getActivityContext(), (SessionManagerConfig)sessionManagerConfig);
                this.sessionManager.initialize();
                this.sessionAgent = new SessionAgent(this.sessionManager.getSessionHandler());
            }
            catch (Exception e) {
                throw new AspectranServiceException("Failed to initialize session manager", (Throwable)e);
            }
        }
    }

    protected void destroySessionManager() {
        if (this.sessionAgent != null) {
            this.sessionAgent.invalidate();
            this.sessionAgent = null;
        }
        if (this.sessionManager != null) {
            this.sessionManager.destroy();
            this.sessionManager = null;
        }
    }
}

