/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.DaemonConfig;
import com.aspectran.core.context.config.ExposalsConfig;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.daemon.activity.DaemonActivity;
import com.aspectran.daemon.service.AbstractDaemonService;
import java.util.Map;

public class AspectranDaemonService
extends AbstractDaemonService {
    private static final Log log = LogFactory.getLog(AspectranDaemonService.class);
    private volatile long pauseTimeout = -1L;

    @Override
    public Translet translate(String name, ParameterMap parameterMap, Map<String, Object> attributeMap) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        MethodType requestMethod = null;
        for (MethodType methodType : MethodType.values()) {
            if (!name.startsWith(methodType.name() + " ")) continue;
            requestMethod = methodType;
            name = name.substring(methodType.name().length()).trim();
        }
        return this.translate(name, requestMethod, parameterMap, attributeMap);
    }

    @Override
    public Translet translate(String name, MethodType method, ParameterMap parameterMap, Map<String, Object> attributeMap) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (!this.isExposable(name)) {
            log.error("Unavailable translet: " + name);
            return null;
        }
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (log.isDebugEnabled()) {
                    log.debug(this.getServiceName() + " is paused, so did not execute translet: " + name);
                }
                return null;
            }
            this.pauseTimeout = 0L;
        }
        DaemonActivity activity = null;
        Translet translet = null;
        try {
            activity = new DaemonActivity(this);
            activity.setParameterMap(parameterMap);
            activity.setAttributeMap(attributeMap);
            activity.prepare(name, method);
            activity.perform();
            translet = activity.getTranslet();
        }
        catch (ActivityTerminatedException e) {
            if (log.isDebugEnabled()) {
                log.debug("Activity terminated: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new AspectranServiceException("An error occurred while processing translet: " + name, (Throwable)e);
        }
        finally {
            if (activity != null) {
                activity.finish();
            }
        }
        return translet;
    }

    public static AspectranDaemonService create(AspectranConfig aspectranConfig) {
        ContextConfig contextConfig = aspectranConfig.touchContextConfig();
        String rootFile = contextConfig.getRootFile();
        if (!StringUtils.hasText((String)rootFile) && !contextConfig.hasAspectranParameters()) {
            contextConfig.setRootFile("classpath:app-config.xml");
        }
        AspectranDaemonService service = new AspectranDaemonService();
        service.prepare(aspectranConfig);
        DaemonConfig daemonConfig = aspectranConfig.getDaemonConfig();
        if (daemonConfig != null) {
            AspectranDaemonService.applyDaemonConfig(service, daemonConfig);
        }
        AspectranDaemonService.setServiceStateListener(service);
        return service;
    }

    private static void applyDaemonConfig(AspectranDaemonService service, DaemonConfig daemonConfig) {
        ExposalsConfig exposalsConfig = daemonConfig.getExposalsConfig();
        if (exposalsConfig != null) {
            String[] includePatterns = exposalsConfig.getIncludePatterns();
            String[] excludePatterns = exposalsConfig.getExcludePatterns();
            service.setExposals(includePatterns, excludePatterns);
        }
    }

    private static void setServiceStateListener(final AspectranDaemonService service) {
        service.setServiceStateListener(new ServiceStateListener(){

            public void started() {
                service.initSessionManager();
                service.pauseTimeout = 0L;
            }

            public void restarted() {
                this.started();
            }

            public void paused(long millis) {
                if (millis > 0L) {
                    service.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    log.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            public void paused() {
                service.pauseTimeout = -1L;
            }

            public void resumed() {
                this.started();
            }

            public void stopped() {
                this.paused();
                service.destroySessionManager();
            }
        });
    }
}

