/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.embed.service;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionAgent;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.AspectranRuntimeException;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.SessionConfig;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.AspectranCoreService;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.embed.activity.AspectranActivity;
import com.aspectran.embed.adapter.AspectranApplicationAdapter;
import com.aspectran.embed.adapter.AspectranSessionAdapter;
import com.aspectran.embed.service.EmbeddedAspectran;
import java.util.Map;

public class DefaultEmbeddedAspectran
extends AspectranCoreService
implements EmbeddedAspectran {
    private static final Log log = LogFactory.getLog(DefaultEmbeddedAspectran.class);
    private SessionManager sessionManager;
    private volatile long pauseTimeout = -1L;

    public DefaultEmbeddedAspectran() {
        super((ApplicationAdapter)new AspectranApplicationAdapter());
        this.determineBasePath();
    }

    public void afterContextLoaded() throws Exception {
        this.sessionManager = new DefaultSessionManager(this.getActivityContext());
        this.sessionManager.setGroupName("EM");
        SessionConfig sessionConfig = (SessionConfig)this.getAspectranConfig().getParameters(AspectranConfig.session);
        if (sessionConfig != null) {
            this.sessionManager.setSessionConfig(sessionConfig);
        }
        this.sessionManager.initialize();
    }

    public void beforeContextDestroy() {
        this.sessionManager.destroy();
        this.sessionManager = null;
    }

    @Override
    public SessionAdapter newSessionAdapter() {
        SessionAgent agent = this.sessionManager.newSessionAgent();
        return new AspectranSessionAdapter(agent);
    }

    @Override
    public Translet translate(String name) {
        return this.translate(name, null, null, null);
    }

    @Override
    public Translet translate(String name, ParameterMap parameterMap) {
        return this.translate(name, null, parameterMap, null);
    }

    @Override
    public Translet translate(String name, ParameterMap parameterMap, Map<String, Object> attributeMap) {
        return this.translate(name, null, parameterMap, attributeMap);
    }

    @Override
    public Translet translate(String name, Map<String, Object> attributeMap) {
        return this.translate(name, null, null, attributeMap);
    }

    @Override
    public Translet translate(String name, MethodType method) {
        return this.translate(name, method, null, null);
    }

    @Override
    public Translet translate(String name, MethodType method, ParameterMap parameterMap) {
        return this.translate(name, method, parameterMap, null);
    }

    @Override
    public Translet translate(String name, MethodType method, Map<String, Object> attributeMap) {
        return this.translate(name, method, null, attributeMap);
    }

    @Override
    public Translet translate(String name, MethodType method, ParameterMap parameterMap, Map<String, Object> attributeMap) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (log.isDebugEnabled()) {
                    log.debug(this.getServiceName() + " is paused, so did not execute translet: " + name);
                }
                return null;
            }
            this.pauseTimeout = 0L;
        }
        AspectranActivity activity = null;
        Translet translet = null;
        try {
            activity = new AspectranActivity(this);
            activity.setParameterMap(parameterMap);
            activity.setAttributeMap(attributeMap);
            activity.prepare(name, method);
            activity.perform();
            translet = activity.getTranslet();
        }
        catch (ActivityTerminatedException e) {
            if (log.isDebugEnabled()) {
                log.debug("Activity terminated; Cause: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new AspectranRuntimeException("An error occurred while processing translet: " + name, (Throwable)e);
        }
        finally {
            if (activity != null) {
                activity.finish();
            }
        }
        return translet;
    }

    @Override
    public String render(String templateId) {
        return this.render(templateId, null, null);
    }

    @Override
    public String render(String templateId, ParameterMap parameterMap) {
        return this.render(templateId, parameterMap, null);
    }

    @Override
    public String render(String templateId, Map<String, Object> attributeMap) {
        return this.render(templateId, null, attributeMap);
    }

    @Override
    public String render(String templateId, ParameterMap parameterMap, Map<String, Object> attributeMap) {
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (log.isDebugEnabled()) {
                    log.debug(this.getServiceName() + " is paused, so did not execute template: " + templateId);
                }
                return null;
            }
            this.pauseTimeout = 0L;
        }
        try {
            InstantActivity activity = new InstantActivity(this.getActivityContext(), parameterMap, attributeMap);
            activity.setSessionAdapter(this.newSessionAdapter());
            this.getActivityContext().getTemplateRenderer().render(templateId, (Activity)activity);
            return activity.getResponseAdapter().getWriter().toString();
        }
        catch (Exception e) {
            throw new AspectranRuntimeException("An error occurred while processing template: " + templateId, (Throwable)e);
        }
    }

    @Override
    public void release() {
        this.stop();
    }

    protected static DefaultEmbeddedAspectran create(AspectranConfig aspectranConfig) {
        String appConfigRootFile;
        ContextConfig contextConfig = aspectranConfig.getContextConfig();
        if (contextConfig == null) {
            contextConfig = aspectranConfig.newContextConfig();
        }
        if (!StringUtils.hasText((String)(appConfigRootFile = contextConfig.getString(ContextConfig.root))) && contextConfig.getParameter(ContextConfig.parameters) == null) {
            contextConfig.putValue(ContextConfig.root, (Object)"classpath:app-config.xml");
        }
        DefaultEmbeddedAspectran aspectran = new DefaultEmbeddedAspectran();
        aspectran.prepare(aspectranConfig);
        DefaultEmbeddedAspectran.setServiceStateListener(aspectran);
        return aspectran;
    }

    private static void setServiceStateListener(final DefaultEmbeddedAspectran aspectran) {
        aspectran.setServiceStateListener(new ServiceStateListener(){

            public void started() {
                aspectran.pauseTimeout = 0L;
            }

            public void restarted() {
                this.started();
            }

            public void paused(long millis) {
                if (millis < 0L) {
                    throw new IllegalArgumentException("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
                aspectran.pauseTimeout = System.currentTimeMillis() + millis;
            }

            public void paused() {
                aspectran.pauseTimeout = -1L;
            }

            public void resumed() {
                this.started();
            }

            public void stopped() {
                this.paused();
            }
        });
    }
}

