/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.embed.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.adapter.BasicSessionAdapter;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.util.OutputStringWriter;
import com.aspectran.embed.adapter.AspectranRequestAdapter;
import com.aspectran.embed.adapter.AspectranResponseAdapter;
import com.aspectran.embed.service.EmbeddedAspectran;
import java.io.Writer;
import java.util.Map;

public class AspectranActivity
extends CoreActivity {
    private final EmbeddedAspectran aspectran;
    private Writer outputWriter;
    private ParameterMap parameterMap;
    private Map<String, Object> attributeMap;
    private String body;

    public AspectranActivity(EmbeddedAspectran aspectran) {
        this(aspectran, null);
    }

    public AspectranActivity(EmbeddedAspectran aspectran, Writer outputWriter) {
        super(aspectran.getActivityContext());
        this.aspectran = aspectran;
        this.outputWriter = outputWriter;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public void setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public void setBody(String body) {
        this.body = body;
    }

    protected void adapt() throws AdapterException {
        try {
            if (this.getOuterActivity() == null) {
                this.setSessionAdapter(this.aspectran.newSessionAdapter());
            } else {
                this.setSessionAdapter(this.getOuterActivity().getSessionAdapter());
            }
            AspectranRequestAdapter requestAdapter = new AspectranRequestAdapter(this.getTranslet().getRequestMethod());
            if (this.body != null) {
                requestAdapter.setBody(this.body);
            }
            this.setRequestAdapter((RequestAdapter)requestAdapter);
            if (this.outputWriter == null) {
                this.outputWriter = new OutputStringWriter();
            }
            AspectranResponseAdapter responseAdapter = new AspectranResponseAdapter(this.outputWriter);
            this.setResponseAdapter((ResponseAdapter)responseAdapter);
        }
        catch (Exception e) {
            throw new AdapterException("Failed to adapt for Aspectran Activity", (Throwable)e);
        }
        super.adapt();
    }

    protected void parseRequest() {
        if (this.getOuterActivity() == null) {
            ((AspectranRequestAdapter)this.getRequestAdapter()).preparse(this.attributeMap, this.parameterMap);
        } else {
            ((AspectranRequestAdapter)this.getRequestAdapter()).preparse(this.getOuterActivity().getRequestAdapter());
        }
        super.parseRequest();
    }

    public void perform() {
        if (this.getOuterActivity() == null && this.getSessionAdapter() != null) {
            ((BasicSessionAdapter)this.getSessionAdapter()).getSessionAgent().access();
        }
        super.perform();
    }

    protected void release() {
        if (this.getOuterActivity() == null && this.getSessionAdapter() != null) {
            ((BasicSessionAdapter)this.getSessionAdapter()).getSessionAgent().complete();
        }
        super.release();
    }

    public <T extends Activity> T newActivity() {
        AspectranActivity activity = new AspectranActivity(this.aspectran, this.outputWriter);
        activity.setIncluded(true);
        return (T)((Object)activity);
    }
}

