/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.embed.service;

import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionAgent;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.config.EmbedConfig;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.service.AspectranCoreService;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.embed.adapter.AspectranSessionAdapter;
import com.aspectran.embed.service.EmbeddedAspectran;

public abstract class AbstractEmbeddedAspectran
extends AspectranCoreService
implements EmbeddedAspectran {
    private SessionManager sessionManager;
    private SessionAgent sessionAgent;

    public AbstractEmbeddedAspectran() {
        this.determineBasePath();
    }

    @Override
    public boolean isExposable(String transletName) {
        return super.isExposable(transletName);
    }

    @Override
    public void release() {
        this.stop();
    }

    @Override
    public SessionAdapter newSessionAdapter() {
        if (this.sessionAgent != null) {
            return new AspectranSessionAdapter(this.sessionAgent);
        }
        return null;
    }

    protected void initSessionManager() {
        SessionManagerConfig sessionManagerConfig;
        if (this.sessionManager != null) {
            throw new IllegalStateException("SessionManager already initialized");
        }
        EmbedConfig embedConfig = this.getAspectranConfig().getEmbedConfig();
        if (embedConfig != null && (sessionManagerConfig = embedConfig.getSessionManagerConfig()) != null && sessionManagerConfig.isStartup()) {
            try {
                DefaultSessionManager sessionManager = new DefaultSessionManager();
                sessionManager.setApplicationAdapter(this.getActivityContext().getApplicationAdapter());
                sessionManager.setSessionManagerConfig(sessionManagerConfig);
                sessionManager.initialize();
                this.sessionManager = sessionManager;
                this.sessionAgent = new SessionAgent(sessionManager.getSessionHandler());
            }
            catch (Exception e) {
                throw new AspectranServiceException("Failed to initialize session manager", (Throwable)e);
            }
        }
    }

    protected void destroySessionManager() {
        if (this.sessionAgent != null) {
            this.sessionAgent.invalidate();
            this.sessionAgent = null;
        }
        if (this.sessionManager != null) {
            this.sessionManager.destroy();
            this.sessionManager = null;
        }
    }
}

