/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.embed.service;

import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.embed.activity.AspectranActivity;
import com.aspectran.embed.service.AbstractEmbeddedAspectran;
import java.util.Map;

public class DefaultEmbeddedAspectran
extends AbstractEmbeddedAspectran {
    private static final Log log = LogFactory.getLog(DefaultEmbeddedAspectran.class);
    private volatile long pauseTimeout = -1L;

    @Override
    public Translet translate(String name) {
        return this.translate(name, null, null, null, null);
    }

    @Override
    public Translet translate(String name, String body) {
        return this.translate(name, null, null, null, body);
    }

    @Override
    public Translet translate(String name, ParameterMap parameterMap) {
        return this.translate(name, null, parameterMap, null, null);
    }

    @Override
    public Translet translate(String name, ParameterMap parameterMap, Map<String, Object> attributeMap) {
        return this.translate(name, null, parameterMap, attributeMap, null);
    }

    @Override
    public Translet translate(String name, Map<String, Object> attributeMap) {
        return this.translate(name, null, null, attributeMap, null);
    }

    @Override
    public Translet translate(String name, MethodType method) {
        return this.translate(name, method, null, null, null);
    }

    @Override
    public Translet translate(String name, MethodType method, ParameterMap parameterMap) {
        return this.translate(name, method, parameterMap, null, null);
    }

    @Override
    public Translet translate(String name, MethodType method, Map<String, Object> attributeMap) {
        return this.translate(name, method, null, attributeMap, null);
    }

    @Override
    public Translet translate(String name, MethodType method, ParameterMap parameterMap, Map<String, Object> attributeMap, String body) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (!this.isExposable(name)) {
            log.error("Unavailable translet: " + name);
            return null;
        }
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (log.isDebugEnabled()) {
                    log.debug(this.getServiceName() + " is paused, so did not execute translet: " + name);
                }
                return null;
            }
            this.pauseTimeout = 0L;
        }
        Translet translet = null;
        try (AspectranActivity activity = null;){
            activity = new AspectranActivity(this);
            activity.setParameterMap(parameterMap);
            activity.setAttributeMap(attributeMap);
            activity.setBody(body);
            activity.prepare(name, method);
            activity.perform();
            translet = activity.getTranslet();
        }
        return translet;
    }

    @Override
    public String render(String templateId) {
        return this.render(templateId, null, null);
    }

    @Override
    public String render(String templateId, ParameterMap parameterMap) {
        return this.render(templateId, parameterMap, null);
    }

    @Override
    public String render(String templateId, Map<String, Object> attributeMap) {
        return this.render(templateId, null, attributeMap);
    }

    @Override
    public String render(String templateId, ParameterMap parameterMap, Map<String, Object> attributeMap) {
        String string;
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (log.isDebugEnabled()) {
                    log.debug(this.getServiceName() + " is paused, so did not execute template: " + templateId);
                }
                return null;
            }
            this.pauseTimeout = 0L;
        }
        InstantActivity activity = new InstantActivity(this.getActivityContext(), parameterMap, attributeMap);
        try {
            activity.setSessionAdapter(this.newSessionAdapter());
            Object result = activity.perform(() -> this.getActivityContext().getTemplateRenderer().render(templateId));
            string = result.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    activity.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new AspectranServiceException("An error occurred while rendering template: " + templateId, (Throwable)e);
            }
        }
        activity.close();
        return string;
    }

    static DefaultEmbeddedAspectran create(AspectranConfig aspectranConfig) {
        ContextConfig contextConfig = aspectranConfig.touchContextConfig();
        String rootFile = contextConfig.getRootFile();
        if (!StringUtils.hasText((String)rootFile) && !contextConfig.hasAspectranParameters()) {
            contextConfig.setRootFile("classpath:app-config.xml");
        }
        DefaultEmbeddedAspectran aspectran = new DefaultEmbeddedAspectran();
        aspectran.prepare(aspectranConfig);
        DefaultEmbeddedAspectran.setServiceStateListener(aspectran);
        return aspectran;
    }

    private static void setServiceStateListener(final DefaultEmbeddedAspectran aspectran) {
        aspectran.setServiceStateListener(new ServiceStateListener(){

            public void started() {
                aspectran.initSessionManager();
                aspectran.pauseTimeout = 0L;
            }

            public void restarted() {
                aspectran.destroySessionManager();
                aspectran.initSessionManager();
                aspectran.pauseTimeout = 0L;
            }

            public void paused(long millis) {
                if (millis > 0L) {
                    aspectran.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    log.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            public void paused() {
                aspectran.pauseTimeout = -1L;
            }

            public void resumed() {
                this.started();
            }

            public void stopped() {
                aspectran.destroySessionManager();
                this.paused();
            }
        });
    }
}

