/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.embed.service;

import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionAgent;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.config.EmbedConfig;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.service.CoreServiceException;
import com.aspectran.core.service.DefaultCoreService;
import com.aspectran.core.support.i18n.message.NoSuchMessageException;
import com.aspectran.embed.adapter.AspectranSessionAdapter;
import com.aspectran.embed.service.EmbeddedAspectran;
import com.aspectran.utils.Assert;
import java.util.Locale;

public abstract class AbstractEmbeddedAspectran
extends DefaultCoreService
implements EmbeddedAspectran {
    private SessionManager sessionManager;
    private SessionAgent sessionAgent;

    AbstractEmbeddedAspectran() {
    }

    @Override
    public SessionAdapter newSessionAdapter() {
        if (this.sessionAgent != null) {
            return new AspectranSessionAdapter(this.sessionAgent);
        }
        return null;
    }

    protected void createSessionManager() {
        SessionManagerConfig sessionManagerConfig;
        Assert.state((this.sessionManager == null ? 1 : 0) != 0, (String)"Session Manager is already exists for embedded aspectran");
        EmbedConfig embedConfig = this.getAspectranConfig().getEmbedConfig();
        if (embedConfig != null && (sessionManagerConfig = embedConfig.getSessionManagerConfig()) != null && sessionManagerConfig.isEnabled()) {
            try {
                DefaultSessionManager sessionManager = new DefaultSessionManager();
                sessionManager.setApplicationAdapter(this.getApplicationAdapter());
                sessionManager.setSessionManagerConfig(sessionManagerConfig);
                sessionManager.initialize();
                this.sessionManager = sessionManager;
                this.sessionAgent = new SessionAgent(sessionManager.getSessionHandler());
            }
            catch (Exception e) {
                throw new CoreServiceException("Failed to create session manager for embedded aspectran", (Throwable)e);
            }
        }
    }

    protected void destroySessionManager() {
        if (this.sessionAgent != null) {
            this.sessionAgent.invalidate();
            this.sessionAgent = null;
        }
        if (this.sessionManager != null) {
            this.sessionManager.destroy();
            this.sessionManager = null;
        }
    }

    @Override
    public Environment getEnvironment() {
        return this.getActivityContext().getEnvironment();
    }

    @Override
    public void release() {
        this.stop();
    }

    @Override
    public <V> V getBean(String id) {
        return (V)this.getActivityContext().getBeanRegistry().getBean(id);
    }

    @Override
    public <V> V getBean(Class<V> type) {
        return (V)this.getActivityContext().getBeanRegistry().getBean(type);
    }

    @Override
    public <V> V getBean(Class<V> type, String id) {
        return (V)this.getActivityContext().getBeanRegistry().getBean(type, id);
    }

    @Override
    public boolean containsBean(String id) {
        return this.getActivityContext().getBeanRegistry().containsBean(id);
    }

    @Override
    public boolean containsBean(Class<?> type) {
        return this.getActivityContext().getBeanRegistry().containsBean(type);
    }

    @Override
    public boolean containsBean(Class<?> type, String id) {
        return this.getActivityContext().getBeanRegistry().containsBean(type, id);
    }

    @Override
    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getActivityContext().getMessageSource().getMessage(code, args, locale);
    }

    @Override
    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.getActivityContext().getMessageSource().getMessage(code, args, defaultMessage, locale);
    }
}

