/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.embed.service;

import com.aspectran.core.activity.InstantAction;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.CoreServiceException;
import com.aspectran.core.support.i18n.message.NoSuchMessageException;
import com.aspectran.embed.service.DefaultEmbeddedAspectran;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.File;
import java.io.Reader;
import java.util.Locale;
import java.util.Map;

public interface EmbeddedAspectran {
    public <V> V execute(InstantAction<V> var1);

    public Translet translate(String var1);

    public Translet translate(String var1, String var2);

    public Translet translate(String var1, Map<String, Object> var2);

    public Translet translate(String var1, ParameterMap var2);

    public Translet translate(String var1, Map<String, Object> var2, ParameterMap var3);

    public Translet translate(String var1, MethodType var2);

    public Translet translate(String var1, MethodType var2, Map<String, Object> var3);

    public Translet translate(String var1, MethodType var2, ParameterMap var3);

    public Translet translate(String var1, MethodType var2, Map<String, Object> var3, ParameterMap var4);

    public Translet translate(String var1, MethodType var2, Map<String, Object> var3, ParameterMap var4, String var5);

    public String render(String var1);

    public String render(String var1, Map<String, Object> var2);

    public String render(String var1, ParameterMap var2);

    public String render(String var1, Map<String, Object> var2, ParameterMap var3);

    public Environment getEnvironment();

    public ApplicationAdapter getApplicationAdapter();

    public <V> V getBean(String var1);

    public <V> V getBean(Class<V> var1);

    public <V> V getBean(Class<V> var1, String var2);

    public boolean containsBean(String var1);

    public boolean containsBean(Class<?> var1);

    public boolean containsBean(Class<?> var1, String var2);

    public String getMessage(String var1, Object[] var2, Locale var3) throws NoSuchMessageException;

    public String getMessage(String var1, Object[] var2, String var3, Locale var4);

    public SessionAdapter newSessionAdapter();

    public void release();

    @NonNull
    public static EmbeddedAspectran run(String aspectranConfigFile) {
        if (aspectranConfigFile == null) {
            throw new IllegalArgumentException("aspectranConfigFile must not be null");
        }
        File configFile = new File(aspectranConfigFile);
        return EmbeddedAspectran.run(configFile);
    }

    @NonNull
    public static EmbeddedAspectran run(File aspectranConfigFile) {
        AspectranConfig aspectranConfig;
        if (aspectranConfigFile == null) {
            throw new IllegalArgumentException("aspectranConfigFile must not be null");
        }
        try {
            aspectranConfig = new AspectranConfig(aspectranConfigFile);
        }
        catch (AponParseException e) {
            throw new CoreServiceException("Error parsing aspectran configuration file: " + aspectranConfigFile, (Throwable)e);
        }
        return EmbeddedAspectran.run(aspectranConfig);
    }

    @NonNull
    public static EmbeddedAspectran run(Reader configFileReader) {
        AspectranConfig aspectranConfig;
        if (configFileReader == null) {
            throw new IllegalArgumentException("configFileReader must not be null");
        }
        try {
            aspectranConfig = new AspectranConfig(configFileReader);
        }
        catch (AponParseException e) {
            throw new CoreServiceException("Error parsing aspectran configuration", (Throwable)e);
        }
        return EmbeddedAspectran.run(aspectranConfig);
    }

    @NonNull
    public static EmbeddedAspectran run(AspectranConfig aspectranConfig) {
        Assert.notNull((Object)aspectranConfig, (String)"aspectranConfig must not be null");
        try {
            DefaultEmbeddedAspectran aspectran = DefaultEmbeddedAspectran.create(aspectranConfig);
            aspectran.start();
            return aspectran;
        }
        catch (CoreServiceException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "EmbeddedAspectran run failed with parameters:" + System.lineSeparator() + aspectranConfig;
            Logger logger = LoggerFactory.getLogger(EmbeddedAspectran.class);
            logger.error(message);
            throw new CoreServiceException("EmbeddedAspectran run failed", (Throwable)e);
        }
    }
}

