/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce;

import com.aspectran.core.component.session.AbstractSessionStore;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public abstract class AbstractLettuceSessionStore
extends AbstractSessionStore {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLettuceSessionStore.class);

    protected abstract void scan(Consumer<SessionData> var1);

    public Set<String> doGetExpired(Set<String> candidates) {
        long now = System.currentTimeMillis();
        HashSet<String> expired = new HashSet<String>();
        this.scan(sessionData -> {
            long expiry = sessionData.getExpiry();
            if (expiry > 0L && expiry < now) {
                expired.add(sessionData.getId());
            }
        });
        for (String id : candidates) {
            if (expired.contains(id)) continue;
            try {
                SessionData data = this.load(id);
                if (data != null) {
                    if (data.getExpiry() <= 0L || data.getExpiry() > now) continue;
                    expired.add(id);
                    continue;
                }
                expired.add(id);
            }
            catch (Exception e) {
                logger.warn("Error checking if session " + id + " has expired", (Throwable)e);
            }
        }
        return expired;
    }

    protected boolean checkExpiry(SessionData data) {
        if (data != null) {
            return data.getExpiry() <= 0L || data.getExpiry() > System.currentTimeMillis();
        }
        return false;
    }
}

