/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce;

import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.redis.lettuce.ConnectionPool;
import com.aspectran.core.component.session.redis.lettuce.RedisConnectionPoolConfig;
import com.aspectran.core.component.session.redis.lettuce.SessionDataCodec;
import com.aspectran.core.util.Assert;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.support.ConnectionPoolSupport;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RedisConnectionPool
implements ConnectionPool<StatefulRedisConnection<String, SessionData>> {
    private final RedisConnectionPoolConfig poolConfig;
    private RedisClient client;
    private GenericObjectPool<StatefulRedisConnection<String, SessionData>> pool;

    public RedisConnectionPool(RedisConnectionPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    @Override
    public StatefulRedisConnection<String, SessionData> getConnection() throws Exception {
        Assert.state((this.pool != null ? 1 : 0) != 0, (String)"No RedisConnectionPool configured");
        return (StatefulRedisConnection)this.pool.borrowObject();
    }

    @Override
    public void initialize(SessionDataCodec codec) {
        Assert.state((this.pool == null ? 1 : 0) != 0, (String)"RedisConnectionPool is already configured");
        RedisURI redisURI = this.poolConfig.getRedisURI();
        if (redisURI == null) {
            throw new IllegalArgumentException("redisURI must not be null");
        }
        this.client = RedisClient.create((RedisURI)redisURI);
        if (this.poolConfig.getClientOptions() != null) {
            this.client.setOptions(this.poolConfig.getClientOptions());
        }
        this.pool = ConnectionPoolSupport.createGenericObjectPool(() -> this.client.connect((RedisCodec)codec), (GenericObjectPoolConfig)this.poolConfig);
    }

    @Override
    public void destroy() {
        if (this.pool != null) {
            this.pool.close();
        }
        if (this.client != null) {
            this.client.shutdown();
        }
    }
}

