/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce;

import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.redis.lettuce.SessionDataSerializationException;
import io.lettuce.core.codec.RedisCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class SessionDataCodec
implements RedisCodec<String, SessionData> {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final Set<String> nonPersistentAttributes;

    public SessionDataCodec(Set<String> nonPersistentAttributes) {
        this.nonPersistentAttributes = nonPersistentAttributes;
    }

    public String decodeKey(ByteBuffer bytes) {
        return UTF8.decode(bytes).toString();
    }

    public SessionData decodeValue(ByteBuffer bytes) {
        try {
            byte[] array = new byte[bytes.remaining()];
            bytes.get(array);
            ByteArrayInputStream bais = new ByteArrayInputStream(array);
            return SessionData.deserialize((InputStream)bais);
        }
        catch (Exception e) {
            throw new SessionDataSerializationException("Error decoding session data", e);
        }
    }

    public ByteBuffer encodeKey(String key) {
        return UTF8.encode(key);
    }

    public ByteBuffer encodeValue(SessionData value) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SessionData.serialize((SessionData)value, (OutputStream)baos, this.nonPersistentAttributes);
            return ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException e) {
            throw new SessionDataSerializationException("Error encoding session data", e);
        }
    }
}

