/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce.cluster;

import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterURIUtil;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import java.net.URI;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RedisClusterConnectionPoolConfig
extends GenericObjectPoolConfig<StatefulRedisClusterConnection<String, SessionData>> {
    private RedisURI[] redisURIs;
    private ClusterClientOptions clusterClientOptions;

    public RedisURI[] getRedisURIs() {
        return this.redisURIs;
    }

    public void setRedisURIs(RedisURI ... redisURIs) {
        if (redisURIs == null || redisURIs.length == 0) {
            throw new IllegalArgumentException("redisURIs must not be null or empty");
        }
        this.redisURIs = redisURIs;
    }

    public void setUri(String uri) {
        if (!StringUtils.hasText((String)uri)) {
            throw new IllegalArgumentException("uri must not be null or empty");
        }
        List redisURIs = RedisClusterURIUtil.toRedisURIs((URI)URI.create(uri));
        this.redisURIs = redisURIs.toArray(new RedisURI[0]);
    }

    public ClusterClientOptions getClusterClientOptions() {
        return this.clusterClientOptions;
    }

    public void setClusterClientOptions(ClusterClientOptions clusterClientOptions) {
        this.clusterClientOptions = clusterClientOptions;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("redisURIs", (Object)this.redisURIs);
        tsb.append("clusterClientOptions", (Object)this.clusterClientOptions);
        return tsb.toString();
    }
}

