/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce.masterreplica;

import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.redis.lettuce.ConnectionPool;
import com.aspectran.core.component.session.redis.lettuce.SessionDataCodec;
import com.aspectran.core.component.session.redis.lettuce.masterreplica.RedisMasterReplicaConnectionPoolConfig;
import com.aspectran.core.util.Assert;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.util.Arrays;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RedisMasterReplicaConnectionPool
implements ConnectionPool<StatefulRedisConnection<String, SessionData>> {
    private final RedisMasterReplicaConnectionPoolConfig poolConfig;
    private RedisClient client;
    private GenericObjectPool<StatefulRedisConnection<String, SessionData>> pool;

    public RedisMasterReplicaConnectionPool(RedisMasterReplicaConnectionPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    @Override
    public StatefulRedisConnection<String, SessionData> getConnection() throws Exception {
        Assert.state((this.pool != null ? 1 : 0) != 0, (String)"No RedisMasterReplicaConnectionPool configured");
        return (StatefulRedisConnection)this.pool.borrowObject();
    }

    @Override
    public void initialize(SessionDataCodec codec) {
        Assert.state((this.pool == null ? 1 : 0) != 0, (String)"RedisMasterReplicaConnectionPool is already configured");
        RedisURI[] redisURIs = this.poolConfig.getRedisURIs();
        if (redisURIs == null || redisURIs.length == 0) {
            throw new IllegalArgumentException("redisURIs must not be null or empty");
        }
        this.client = RedisClient.create();
        if (this.poolConfig.getClientOptions() != null) {
            this.client.setOptions(this.poolConfig.getClientOptions());
        }
        this.pool = ConnectionPoolSupport.createGenericObjectPool(() -> {
            StatefulRedisMasterReplicaConnection connection = redisURIs.length == 1 ? MasterReplica.connect((RedisClient)this.client, (RedisCodec)codec, (RedisURI)redisURIs[0]) : MasterReplica.connect((RedisClient)this.client, (RedisCodec)codec, Arrays.asList(redisURIs));
            connection.setReadFrom(ReadFrom.UPSTREAM_PREFERRED);
            return connection;
        }, (GenericObjectPoolConfig)this.poolConfig);
    }

    @Override
    public void destroy() {
        if (this.pool != null) {
            this.pool.close();
            this.pool = null;
        }
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
    }
}

