/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.console.AnsiStyleHandler;
import java.util.Arrays;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class JLineAnsiStyler {
    private static final Log log = LogFactory.getLog(JLineAnsiStyler.class);

    public static String parse(String input) {
        return JLineAnsiStyler.parse(input, null);
    }

    public static String parse(String input, Terminal terminal) {
        if (input == null || !input.contains("{{") || !input.contains("}}")) {
            return input;
        }
        final AttributedStringBuilder asb = new AttributedStringBuilder(input.length());
        AnsiStyleHandler handler = new AnsiStyleHandler(){

            public void character(char c) {
                asb.append(c);
            }

            public void attribute(String ... attrs) {
                asb.style(JLineAnsiStyler.makeStyle(asb.style(), attrs));
            }
        };
        handler.handle((CharSequence)input);
        return asb.toAnsi(terminal);
    }

    public static AttributedStyle makeStyle(String ... styles) {
        AttributedStyle attributedStyle = AttributedStyle.DEFAULT;
        return JLineAnsiStyler.makeStyle(attributedStyle, styles);
    }

    public static AttributedStyle makeStyle(AttributedStyle as, String ... styles) {
        String[] stringArray = styles;
        int n = stringArray.length;
        block120: for (int i = 0; i < n; ++i) {
            String style;
            switch (style = stringArray[i]) {
                case "off": {
                    as = AttributedStyle.DEFAULT;
                    continue block120;
                }
                case "bold": {
                    as = as.bold();
                    continue block120;
                }
                case "faint": {
                    as = as.faint();
                    continue block120;
                }
                case "bold:off": {
                    as = as.boldOff().faintOff();
                    continue block120;
                }
                case "italic": {
                    as = as.italic();
                    continue block120;
                }
                case "italic:off": {
                    as = as.italicOff();
                    continue block120;
                }
                case "underline": {
                    as = as.underline();
                    continue block120;
                }
                case "underline:off": {
                    as = as.underlineOff();
                    continue block120;
                }
                case "blink": {
                    as = as.blink();
                    continue block120;
                }
                case "blink:off": {
                    as = as.blinkOff();
                    continue block120;
                }
                case "inverse": {
                    as = as.inverse();
                    continue block120;
                }
                case "inverse:off": {
                    as = as.inverseOff();
                    continue block120;
                }
                case "conceal": {
                    as = as.conceal();
                    continue block120;
                }
                case "conceal:off": {
                    as = as.concealOff();
                    continue block120;
                }
                case "crossedOut": {
                    as = as.crossedOut();
                    continue block120;
                }
                case "crossedOut:off": {
                    as = as.crossedOutOff();
                    continue block120;
                }
                case "black": 
                case "fg:black": {
                    as = as.foreground(0);
                    continue block120;
                }
                case "red": 
                case "fg:red": {
                    as = as.foreground(1);
                    continue block120;
                }
                case "green": 
                case "fg:green": {
                    as = as.foreground(2);
                    continue block120;
                }
                case "yellow": 
                case "fg:yellow": {
                    as = as.foreground(3);
                    continue block120;
                }
                case "blue": 
                case "fg:blue": {
                    as = as.foreground(4);
                    continue block120;
                }
                case "magenta": 
                case "fg:magenta": {
                    as = as.foreground(5);
                    continue block120;
                }
                case "cyan": 
                case "fg:cyan": {
                    as = as.foreground(6);
                    continue block120;
                }
                case "white": 
                case "fg:white": {
                    as = as.foreground(7);
                    continue block120;
                }
                case "BLACK": 
                case "fg:BLACK": {
                    as = as.foreground(8);
                    continue block120;
                }
                case "RED": 
                case "fg:RED": {
                    as = as.foreground(9);
                    continue block120;
                }
                case "GREEN": 
                case "fg:GREEN": {
                    as = as.foreground(10);
                    continue block120;
                }
                case "YELLOW": 
                case "fg:YELLOW": {
                    as = as.foreground(11);
                    continue block120;
                }
                case "BLUE": 
                case "fg:BLUE": {
                    as = as.foreground(12);
                    continue block120;
                }
                case "MAGENTA": 
                case "fg:MAGENTA": {
                    as = as.foreground(13);
                    continue block120;
                }
                case "CYAN": 
                case "fg:CYAN": {
                    as = as.foreground(14);
                    continue block120;
                }
                case "WHITE": 
                case "fg:WHITE": {
                    as = as.foreground(15);
                    continue block120;
                }
                case "fg:off": {
                    as = as.foregroundOff();
                    continue block120;
                }
                case "bg:black": {
                    as = as.background(0);
                    continue block120;
                }
                case "bg:red": {
                    as = as.background(1);
                    continue block120;
                }
                case "bg:green": {
                    as = as.background(2);
                    continue block120;
                }
                case "bg:yellow": {
                    as = as.background(3);
                    continue block120;
                }
                case "bg:blue": {
                    as = as.background(4);
                    continue block120;
                }
                case "bg:magenta": {
                    as = as.background(5);
                    continue block120;
                }
                case "bg:cyan": {
                    as = as.background(6);
                    continue block120;
                }
                case "bg:white": {
                    as = as.background(7);
                    continue block120;
                }
                case "bg:BLACK": {
                    as = as.background(8);
                    continue block120;
                }
                case "bg:RED": {
                    as = as.background(9);
                    continue block120;
                }
                case "bg:GREEN": {
                    as = as.background(10);
                    continue block120;
                }
                case "bg:YELLOW": {
                    as = as.background(11);
                    continue block120;
                }
                case "bg:BLUE": {
                    as = as.background(12);
                    continue block120;
                }
                case "bg:MAGENTA": {
                    as = as.background(13);
                    continue block120;
                }
                case "bg:CYAN": {
                    as = as.background(14);
                    continue block120;
                }
                case "bg:WHITE": {
                    as = as.background(15);
                    continue block120;
                }
                case "bg:off": {
                    as = as.backgroundOff();
                    continue block120;
                }
                default: {
                    String[] arr;
                    int col;
                    if (style.startsWith("rgb:") && (col = JLineAnsiStyler.rgbColor(arr = StringUtils.split((String)style.substring(4), (char)':'))) > -1) {
                        as = as.foreground(col);
                    }
                    if (style.startsWith("fg:rgb:") && (col = JLineAnsiStyler.rgbColor(arr = StringUtils.split((String)style.substring(7), (char)':'))) > -1) {
                        as = as.foreground(col);
                    }
                    if (!style.startsWith("bg:rgb:") || (col = JLineAnsiStyler.rgbColor(arr = StringUtils.split((String)style.substring(7), (char)':'))) <= -1) continue block120;
                    as = as.background(col);
                }
            }
        }
        return as;
    }

    private static int rgbColor(String[] rgb) {
        if (rgb.length == 3) {
            try {
                int r = Integer.parseInt(rgb[0]);
                int b = Integer.parseInt(rgb[1]);
                int g = Integer.parseInt(rgb[2]);
                return 16 + (r >> 3) * 36 + (g >> 3) * 6 + (b >> 3);
            }
            catch (NumberFormatException e) {
                log.warn("Parsing RGB color failed: " + Arrays.toString(rgb), (Throwable)e);
            }
        }
        return -1;
    }
}

