/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.jline.console;

import com.aspectran.shell.command.ConsoleTerminatedException;
import com.aspectran.shell.console.AbstractConsole;
import com.aspectran.shell.console.UnclosablePrintWriter;
import com.aspectran.shell.jline.console.JLineAnsiStringWriter;
import com.aspectran.shell.jline.console.JLineAnsiStyler;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jline.builtins.Options;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class JLineConsole
extends AbstractConsole {
    private static final String APP_NAME = "Aspectran Shell";
    private static final Character MASK_CHAR = Character.valueOf('*');
    private static final String encoding = Charset.defaultCharset().name();
    private final Terminal terminal = TerminalBuilder.builder().encoding(encoding).build();
    private final LineReader reader = LineReaderBuilder.builder().appName("Aspectran Shell").terminal(this.terminal).build();
    private final LineReader commandReader = LineReaderBuilder.builder().appName("Aspectran Shell").terminal(this.terminal).build();
    private AttributedStyle style;

    public String readCommandLine() {
        try {
            String prompt = this.toAnsi(this.getCommandPrompt());
            return this.commandReader.readLine(prompt);
        }
        catch (UserInterruptException e) {
            if (this.confirmQuit()) {
                throw new ConsoleTerminatedException();
            }
            return null;
        }
    }

    private boolean confirmQuit() {
        String confirm = this.toAnsi("{{yellow}}Are you sure you want to quit [{{bold}}Y{{bold:off}}/{{bold}}n{{bold:off}}]?{{off}}");
        String yn = this.readLine(confirm);
        return yn.isEmpty() || yn.equalsIgnoreCase("Y");
    }

    public String readLine() {
        return this.readLine(null);
    }

    public String readLine(String prompt) {
        try {
            return this.reader.readLine(prompt);
        }
        catch (UserInterruptException e) {
            throw new ConsoleTerminatedException();
        }
    }

    public String readLine(String format, Object ... args) {
        return this.readLine(String.format(format, args));
    }

    public String readPassword() {
        return this.readPassword(null);
    }

    public String readPassword(String prompt) {
        try {
            return this.reader.readLine(prompt, MASK_CHAR);
        }
        catch (UserInterruptException e) {
            throw new ConsoleTerminatedException();
        }
    }

    public String readPassword(String format, Object ... args) {
        return this.readPassword(String.format(format, args));
    }

    public void write(String string) {
        if (this.style != null) {
            AttributedString as = new AttributedString((CharSequence)string, this.style);
            this.writeRawText(as.toAnsi(this.terminal));
        } else {
            this.writeRawText(this.toAnsi(string));
        }
    }

    public void write(String format, Object ... args) {
        this.write(String.format(format, args));
    }

    public void writeLine(String string) {
        this.write(string);
        this.writeLine();
    }

    public void writeLine(String format, Object ... args) {
        this.write(format, args);
        this.writeLine();
    }

    public void writeLine() {
        this.writeRawText(Options.NL);
    }

    private void writeRawText(String string) {
        try {
            this.getWriter().write(string);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void clearScreen() {
        this.writeRawText("\u001b[2J");
        this.flush();
    }

    public void flush() {
        try {
            this.getWriter().flush();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Writer getUnclosableWriter() {
        JLineAnsiStringWriter writer = new JLineAnsiStringWriter(this.terminal, this.getWriter());
        return new UnclosablePrintWriter((Writer)writer);
    }

    public String getEncoding() {
        return encoding;
    }

    public OutputStream getOutput() {
        return this.terminal.output();
    }

    public Writer getWriter() {
        return this.terminal.writer();
    }

    public void setStyle(String ... styles) {
        this.style = JLineAnsiStyler.makeStyle(styles);
    }

    public void offStyle() {
        this.style = null;
    }

    private String toAnsi(String string) {
        return JLineAnsiStyler.parse(string, this.terminal);
    }
}

