/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleList;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.adapter.ShellRequestAdapter;
import com.aspectran.shell.adapter.ShellResponseAdapter;
import com.aspectran.shell.command.ConsoleTerminatedException;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.console.MultiWriter;
import com.aspectran.shell.service.ShellService;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ShellActivity
extends CoreActivity {
    private static final Log log = LogFactory.getLog(ShellActivity.class);
    private final ShellService service;
    private final Console console;
    private final Writer[] redirectionWriters;

    public ShellActivity(ShellService service, Writer[] redirectionWriters) {
        super(service.getActivityContext());
        this.service = service;
        this.console = service.getConsole();
        this.redirectionWriters = redirectionWriters;
    }

    protected void adapt() throws AdapterException {
        try {
            Writer outputWriter;
            this.setSessionAdapter(this.service.newSessionAdapter());
            ShellRequestAdapter requestAdapter = new ShellRequestAdapter();
            requestAdapter.setEncoding(this.console.getEncoding());
            this.setRequestAdapter((RequestAdapter)requestAdapter);
            if (this.redirectionWriters == null) {
                outputWriter = this.console.getUnclosableWriter();
            } else {
                ArrayList<Writer> writerList = new ArrayList<Writer>(this.redirectionWriters.length + 1);
                writerList.add(this.console.getUnclosableWriter());
                Collections.addAll(writerList, this.redirectionWriters);
                outputWriter = new MultiWriter(writerList.toArray(new Writer[0]));
            }
            ShellResponseAdapter responseAdapter = new ShellResponseAdapter(outputWriter);
            responseAdapter.setEncoding(this.console.getEncoding());
            this.setResponseAdapter((ResponseAdapter)responseAdapter);
            super.adapt();
        }
        catch (Exception e) {
            throw new AdapterException("Failed to specify adapters required for shell service activity", (Throwable)e);
        }
    }

    protected void parseRequest() {
        this.showDescription();
        this.receiveParameters();
        this.parseDeclaredParameters();
        this.receiveAttributes();
        this.parseDeclaredAttributes();
    }

    private void showDescription() {
        String description;
        if (this.service.isVerbose() && (description = this.getTranslet().getDescription()) != null) {
            this.console.writeLine(description);
            this.console.flush();
        }
    }

    private void receiveParameters() {
        ItemRuleMap parameterItemRuleMap = this.getRequestRule().getParameterItemRuleMap();
        if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
            ItemRuleList parameterItemRuleList = new ItemRuleList(parameterItemRuleMap.values());
            this.console.setStyle("GREEN");
            this.console.writeLine("Required parameters:");
            this.console.offStyle();
            for (ItemRule itemRule : parameterItemRuleList) {
                Token[] tokens = itemRule.getAllTokens();
                if (tokens == null) {
                    Token t = new Token(TokenType.PARAMETER, itemRule.getName());
                    t.setDefaultValue(itemRule.getDefaultValue());
                    tokens = new Token[]{t};
                }
                String mandatoryMarker = itemRule.isMandatory() ? " * " : "   ";
                this.console.setStyle("YELLOW");
                this.console.write(mandatoryMarker);
                this.console.offStyle();
                this.console.setStyle("bold");
                this.console.write("%s: ", itemRule.getName());
                this.console.offStyle();
                this.console.writeLine(TokenParser.toString((Token[])tokens));
            }
            this.enterRequiredParameters(parameterItemRuleList);
        }
    }

    private void enterRequiredParameters(ItemRuleList parameterItemRuleList) {
        ItemRuleList missingItemRules1 = this.enterEachParameter(parameterItemRuleList);
        if (missingItemRules1 != null) {
            this.console.setStyle("YELLOW");
            this.console.writeLine("Required parameters are missing.");
            this.console.offStyle();
            ItemRuleList missingItemRules2 = this.enterEachParameter(missingItemRules1);
            if (missingItemRules2 != null) {
                String[] itemNames = missingItemRules2.getItemNames();
                this.console.setStyle("RED");
                this.console.writeLine("Missing required parameters:");
                this.console.setStyle("WHITE");
                for (String name : itemNames) {
                    this.console.writeLine("   %s", name);
                }
                this.console.offStyle();
                this.terminate("Required parameters are missing");
            }
        }
    }

    private void receiveAttributes() {
        ItemRuleMap attributeItemRuleMap = this.getRequestRule().getAttributeItemRuleMap();
        if (attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
            ItemRuleList attributeItemRuleList = new ItemRuleList(attributeItemRuleMap.values());
            this.console.setStyle("GREEN");
            this.console.writeLine("Required attributes:");
            this.console.offStyle();
            for (ItemRule itemRule : attributeItemRuleList) {
                Token[] tokens = itemRule.getAllTokens();
                if (tokens == null) {
                    Token t = new Token(TokenType.PARAMETER, itemRule.getName());
                    t.setDefaultValue(itemRule.getDefaultValue());
                    tokens = new Token[]{t};
                }
                String mandatoryMarker = itemRule.isMandatory() ? " * " : "   ";
                this.console.setStyle("YELLOW");
                this.console.write(mandatoryMarker);
                this.console.offStyle();
                this.console.setStyle("bold");
                this.console.write("%s: ", itemRule.getName());
                this.console.offStyle();
                this.console.writeLine(TokenParser.toString((Token[])tokens));
            }
            this.enterRequiredAttributes(attributeItemRuleList);
        }
    }

    private void enterRequiredAttributes(ItemRuleList attributeItemRuleList) {
        ItemRuleList missingItemRules1 = this.enterEachParameter(attributeItemRuleList);
        if (missingItemRules1 != null) {
            this.console.setStyle("YELLOW");
            this.console.writeLine("Required attributes are missing.");
            this.console.offStyle();
            ItemRuleList missingItemRules2 = this.enterEachParameter(missingItemRules1);
            if (missingItemRules2 != null) {
                String[] itemNames = missingItemRules2.getItemNames();
                this.console.setStyle("RED");
                this.console.writeLine("Missing required attributes:");
                this.console.setStyle("WHITE");
                for (String name : itemNames) {
                    this.console.writeLine("   %s", name);
                }
                this.console.offStyle();
                this.terminate("Required attributes are missing");
            }
        }
    }

    private ItemRuleList enterEachParameter(ItemRuleList itemRuleList) {
        this.console.setStyle("GREEN");
        this.console.writeLine("Enter a value for each token:");
        this.console.offStyle();
        LinkedHashSet<ItemRule> missingItemRules = new LinkedHashSet<ItemRule>();
        try {
            LinkedHashMap inputTokens = new LinkedHashMap();
            for (ItemRule itemRule : itemRuleList) {
                Token[] tokens = itemRule.getAllTokens();
                if (tokens == null || tokens.length == 0) {
                    Token[] t = new Token(TokenType.PARAMETER, itemRule.getName());
                    t.setDefaultValue(itemRule.getDefaultValue());
                    tokens = new Token[]{t};
                }
                for (Token t1 : tokens) {
                    Set<ItemRule> rules;
                    if (t1.getType() != TokenType.PARAMETER) continue;
                    boolean exists = false;
                    for (Token t2 : inputTokens.keySet()) {
                        if (!t2.equals((Object)t1)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        rules = (Set)inputTokens.get(t1);
                        rules.add(itemRule);
                        continue;
                    }
                    rules = new LinkedHashSet();
                    rules.add(itemRule);
                    inputTokens.put(t1, rules);
                }
            }
            for (Map.Entry entry : inputTokens.entrySet()) {
                Token token = (Token)entry.getKey();
                String value = this.getRequestAdapter().getParameter(token.getName());
                if (value != null) {
                    this.console.writeLine("   %s: %s", token.stringify(), value);
                    continue;
                }
                Set rules = (Set)entry.getValue();
                boolean security = false;
                for (ItemRule ir : rules) {
                    if (!ir.isSecurity()) continue;
                    security = true;
                    break;
                }
                if ((value = security ? this.console.readPassword("   %s: ", token.stringify()) : this.console.readLine("   %s: ", token.stringify())) == null || value.isEmpty()) {
                    value = token.getDefaultValue();
                }
                if (value != null) {
                    this.getRequestAdapter().setParameter(token.getName(), value);
                    continue;
                }
                for (ItemRule ir : rules) {
                    if (!ir.isMandatory()) continue;
                    missingItemRules.add(ir);
                }
            }
        }
        catch (ConsoleTerminatedException e) {
            log.info("User interrupt occurred");
            this.terminate("User interrupt occurred");
        }
        return missingItemRules.isEmpty() ? null : new ItemRuleList(missingItemRules);
    }

    public <T extends Activity> T newActivity() {
        ShellActivity activity = new ShellActivity(this.service, this.redirectionWriters);
        activity.setIncluded(true);
        return (T)((Object)activity);
    }
}

