/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.HelpFormatter;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionParserException;
import com.aspectran.shell.command.option.Options;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;

public abstract class AbstractCommand
implements Command {
    private final CommandRegistry registry;
    protected final Options options = new Options();

    public AbstractCommand(CommandRegistry registry) {
        this.registry = registry;
    }

    public ShellService getService() {
        return this.registry.getService();
    }

    public Console getConsole() {
        return this.getService().getConsole();
    }

    public CommandRegistry getCommandRegistry() {
        return this.registry;
    }

    protected void addOption(Option option) {
        this.options.addOption(option);
    }

    protected ParsedOptions parse(String[] args) throws OptionParserException {
        return this.registry.getParser().parse(this.options, args);
    }

    @Override
    public void printUsage() {
        this.printUsage(this.getConsole());
    }

    @Override
    public void printUsage(Console console) {
        HelpFormatter formatter = new HelpFormatter(console);
        if (this.getDescriptor().getUsage() != null && this.getDescriptor().getUsage().length() > 0) {
            formatter.printHelp(this.getDescriptor().getUsage(), this.options, false);
        } else {
            formatter.printHelp(this.getDescriptor().getName(), this.options, true);
        }
    }
}

