/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.shell.command.CommandLineRedirection;
import com.aspectran.shell.console.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLineParser {
    private static final Pattern REDIRECTION_OPERATOR_PATTERN = Pattern.compile("(>>)|(>)|(\")|(')");
    private static final char ESCAPE = '\\';
    private MethodType requestMethod;
    private String command;
    private List<CommandLineRedirection> redirectionList;

    private CommandLineParser() {
    }

    public MethodType getRequestMethod() {
        return this.requestMethod;
    }

    public String getCommand() {
        return this.command;
    }

    public List<CommandLineRedirection> getRedirectionList() {
        return this.redirectionList;
    }

    public Writer[] getRedirectionWriters(Console console) throws FileNotFoundException, UnsupportedEncodingException {
        if (this.redirectionList != null) {
            ArrayList<OutputStreamWriter> writerList = new ArrayList<OutputStreamWriter>(this.redirectionList.size());
            for (CommandLineRedirection redirection : this.redirectionList) {
                File file = new File(redirection.getOperand());
                boolean append = redirection.getOperator() == CommandLineRedirection.Operator.APPEND_OUT;
                FileOutputStream stream = new FileOutputStream(file, append);
                writerList.add(new OutputStreamWriter((OutputStream)stream, console.getEncoding()));
            }
            return writerList.toArray(new Writer[0]);
        }
        return null;
    }

    private void parse(String commandLine) {
        String[] tokens = CommandLineParser.splitCommandLine(commandLine);
        if (tokens.length > 1) {
            this.requestMethod = MethodType.resolve((String)tokens[0]);
            if (this.requestMethod != null) {
                this.command = commandLine.substring(tokens[0].length()).trim();
            }
        }
        if (this.requestMethod == null) {
            this.command = commandLine;
        }
        this.parseRedirection(this.command);
    }

    private void parseRedirection(String buffer) {
        Matcher matcher = REDIRECTION_OPERATOR_PATTERN.matcher(buffer);
        ArrayList<CommandLineRedirection> redirectionList = new ArrayList<CommandLineRedirection>();
        CommandLineRedirection prevRedirectionOperation = null;
        boolean haveDoubleQuote = false;
        boolean haveSingleQuote = false;
        while (matcher.find()) {
            String string;
            if (matcher.group(1) != null && !haveDoubleQuote && !haveSingleQuote) {
                string = buffer.substring(0, matcher.start(1)).trim();
                if (prevRedirectionOperation != null) {
                    prevRedirectionOperation.setOperand(string);
                } else {
                    this.command = string;
                }
                prevRedirectionOperation = new CommandLineRedirection(CommandLineRedirection.Operator.APPEND_OUT);
                redirectionList.add(prevRedirectionOperation);
                buffer = buffer.substring(matcher.end(1));
                matcher = REDIRECTION_OPERATOR_PATTERN.matcher(buffer);
                continue;
            }
            if (matcher.group(2) != null && !haveDoubleQuote && !haveSingleQuote) {
                string = buffer.substring(0, matcher.start(2)).trim();
                if (prevRedirectionOperation != null) {
                    prevRedirectionOperation.setOperand(string);
                } else {
                    this.command = string;
                }
                prevRedirectionOperation = new CommandLineRedirection(CommandLineRedirection.Operator.OVERWRITE_OUT);
                redirectionList.add(prevRedirectionOperation);
                buffer = buffer.substring(matcher.end(2));
                matcher = REDIRECTION_OPERATOR_PATTERN.matcher(buffer);
                continue;
            }
            if (matcher.group(3) != null) {
                if (matcher.start(3) != 0 && buffer.charAt(matcher.start(3) - 1) == '\\' || haveSingleQuote) continue;
                haveDoubleQuote = !haveDoubleQuote;
                continue;
            }
            if (matcher.group(4) == null || matcher.start(4) != 0 && buffer.charAt(matcher.start(4) - 1) == '\\' || haveDoubleQuote) continue;
            haveSingleQuote = !haveSingleQuote;
        }
        if (prevRedirectionOperation != null) {
            prevRedirectionOperation.setOperand(buffer.trim());
        }
        this.redirectionList = redirectionList.size() > 0 ? redirectionList : null;
    }

    public static CommandLineParser parseCommandLine(String commandLine) {
        CommandLineParser parser = new CommandLineParser();
        parser.parse(commandLine);
        return parser;
    }

    public static String serialize(List<CommandLineRedirection> redirectionList) {
        StringBuilder sb = new StringBuilder();
        if (redirectionList != null) {
            for (CommandLineRedirection redirection : redirectionList) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append((Object)redirection.getOperator()).append(" ");
                sb.append(redirection.getOperand());
            }
        }
        return sb.toString();
    }

    public static String[] splitCommandLine(String commandLine) {
        return StringUtils.tokenize((String)commandLine, (String)" ", (boolean)true);
    }
}

