/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.core.context.resource.AspectranClassLoader;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.option.DefaultOptionParser;
import com.aspectran.shell.command.option.OptionParser;
import com.aspectran.shell.service.ShellService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class CommandRegistry {
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();
    private final OptionParser parser = new DefaultOptionParser();
    private ShellService service;

    public CommandRegistry(ShellService service) {
        this.service = service;
    }

    public ShellService getService() {
        return this.service;
    }

    public OptionParser getParser() {
        return this.parser;
    }

    public Command getCommand(String commandName) {
        return this.commands.get(commandName);
    }

    public void addCommand(String ... classNames) {
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    ClassLoader classLoader = AspectranClassLoader.getDefaultClassLoader();
                    Class<?> commandClass = classLoader.loadClass(className);
                    this.addCommand(commandClass);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unable to load Command class: " + className, e);
                }
            }
        }
    }

    public void addCommand(Class<? extends Command> commandClass) {
        Command command = (Command)ClassUtils.createInstance(commandClass, (Object[])new Object[]{this});
        this.commands.put(command.getDescriptor().getName(), command);
    }

    public Collection<Command> getAllCommands() {
        return this.commands.values();
    }
}

