/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.core.component.translet.TransletNotFoundException;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandLineParser;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.ConsoleTerminatedException;
import com.aspectran.shell.command.builtin.QuitCommand;
import com.aspectran.shell.command.option.OptionParserException;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;
import java.util.Arrays;

public class ShellCommander {
    private static final Log log = LogFactory.getLog(ShellCommander.class);
    private final ShellService service;
    private final Console console;
    private final CommandRegistry commandRegistry;

    public ShellCommander(ShellService service) {
        this.service = service;
        this.console = service.getConsole();
        if (service.getCommandRegistry() != null) {
            this.commandRegistry = service.getCommandRegistry();
        } else {
            this.commandRegistry = new CommandRegistry(service);
            this.commandRegistry.addCommand(QuitCommand.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform() {
        block15: while (true) {
            try {
                while (true) {
                    String commandLine;
                    if ((commandLine = this.console.readCommandLine()) == null || (commandLine = commandLine.trim()).isEmpty()) {
                        continue;
                    }
                    CommandLineParser commandLineParser = CommandLineParser.parseCommandLine(commandLine);
                    String[] arr = CommandLineParser.splitCommandLine(commandLineParser.getCommand());
                    String commandName = arr[0];
                    String[] args = Arrays.copyOfRange(arr, 1, arr.length);
                    Command command = this.commandRegistry.getCommand(commandName);
                    if (command != null) {
                        try {
                            String result = command.execute(args);
                            if (result == null) continue block15;
                            this.console.writeLine(result);
                            continue block15;
                        }
                        catch (ConsoleTerminatedException e) {
                            throw e;
                        }
                        catch (OptionParserException e) {
                            this.console.writeLine(e.getMessage());
                            command.printUsage();
                            continue;
                        }
                        catch (Exception e) {
                            log.error("Command execution failed", (Throwable)e);
                            continue;
                        }
                    }
                    try {
                        this.service.execute(commandLine);
                        this.console.writeLine();
                        continue block15;
                    }
                    catch (TransletNotFoundException e) {
                        this.console.writeLine("No command or executable translet mapped to '" + e.getTransletName() + "'");
                        continue;
                    }
                    catch (ConsoleTerminatedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        log.error("Command execution failed", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (ConsoleTerminatedException commandLine) {
                if (!this.service.isActive() || !log.isDebugEnabled()) return;
                log.debug("Do not terminate this application while releasing all resources");
                return;
            }
            catch (Exception e) {
                try {
                    log.error("Error occurred while processing shell command", (Throwable)e);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (this.service.isActive() && log.isDebugEnabled()) {
                        log.debug("Do not terminate this application while releasing all resources");
                    }
                }
            }
            continue;
            break;
        }
    }
}

