/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtin;

import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionUtils;
import com.aspectran.shell.command.option.ParsedOptions;
import java.util.Collection;

public class HelpCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtin";
    private static final String COMMAND_NAME = "help";
    private String newLine = System.getProperty("line.separator");
    private CommandDescriptor descriptor = new CommandDescriptor();

    public HelpCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public String execute(String[] args) throws Exception {
        ParsedOptions options = this.parse(args);
        String[] filteredCommands = null;
        if (options.hasArgs()) {
            filteredCommands = options.getArgs();
        }
        if (filteredCommands == null) {
            this.getService().printHelp();
        }
        if (filteredCommands != null && filteredCommands.length == 1) {
            Command command = this.getCommandRegistry().getCommand(filteredCommands[0]);
            this.getConsole().writeLine(command.getDescriptor().getDescription());
            command.printUsage();
        } else {
            this.getConsole().setStyle("bold");
            this.getConsole().writeLine("Built-in commands used in this application:");
            this.getConsole().offStyle();
            this.printHelp(filteredCommands);
        }
        return null;
    }

    private void printHelp(String[] filteredCommands) {
        int lineWidth = 74;
        int commandWidth = this.maxLengthOfCommandName(filteredCommands);
        String lpad = OptionUtils.createPadding(3);
        String dpad = OptionUtils.createPadding(3);
        for (Command command : this.getCommandRegistry().getAllCommands()) {
            String line;
            String name = command.getDescriptor().getName();
            if (commandWidth != 0 && filteredCommands != null && !this.contains(name, filteredCommands) || (line = this.renderCommand(command, 74, commandWidth, lpad, dpad)) == null) continue;
            this.getConsole().writeLine(line);
        }
    }

    private int maxLengthOfCommandName(String[] filteredCommands) {
        int max = 0;
        for (Command command : this.getCommandRegistry().getAllCommands()) {
            String commandName = command.getDescriptor().getName();
            if (filteredCommands != null && !this.contains(commandName, filteredCommands) || commandName.length() <= max) continue;
            max = commandName.length();
        }
        return max;
    }

    private boolean contains(String commandName, String[] filteredCommands) {
        for (String target : filteredCommands) {
            if (!commandName.equals(target)) continue;
            return true;
        }
        return false;
    }

    private String renderCommand(Command command, int lineWidth, int commandWidth, String leftPad, String descPad) {
        String name = command.getDescriptor().getName();
        String desc = command.getDescriptor().getDescription();
        StringBuilder sb = new StringBuilder();
        sb.append(leftPad).append(name);
        if (name.length() < commandWidth) {
            sb.append(OptionUtils.createPadding(commandWidth - name.length()));
        }
        sb.append(descPad);
        int nextLineTabStop = commandWidth + descPad.length();
        this.renderWrappedText(sb, lineWidth, nextLineTabStop, desc);
        return sb.length() > 0 ? sb.toString() : null;
    }

    private StringBuilder renderWrappedText(StringBuilder sb, int width, int nextLineTabStop, String text) {
        int pos = OptionUtils.findWrapPos(text, width, 0);
        if (pos == -1) {
            sb.append(OptionUtils.rtrim(text));
            return sb;
        }
        sb.append(OptionUtils.rtrim(text.substring(0, pos))).append(this.newLine);
        if (nextLineTabStop >= width) {
            nextLineTabStop = 1;
        }
        String padding = OptionUtils.createPadding(nextLineTabStop);
        while (true) {
            if ((pos = OptionUtils.findWrapPos(text = padding + text.substring(pos).trim(), width, 0)) == -1) {
                sb.append(text);
                return sb;
            }
            if (text.length() > width && pos == nextLineTabStop - 1) {
                pos = width;
            }
            sb.append(OptionUtils.rtrim(text.substring(0, pos))).append(this.newLine);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return HelpCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return HelpCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Display information about builtin commands";
        }

        @Override
        public String getUsage() {
            return "help [command [command2 [command3] ...]]";
        }

        @Override
        public Collection<Option> getOptions() {
            return HelpCommand.this.options.getOptions();
        }
    }
}

