/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtin;

import com.aspectran.core.util.StringUtils;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import java.util.Map;

public class SysInfoCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtin";
    private static final String COMMAND_NAME = "sysinfo";
    private CommandDescriptor descriptor = new CommandDescriptor();

    public SysInfoCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(new Option("props", "Displays the JVM's system properties"));
        this.addOption(Option.builder("cp").longOpt("classpath").desc("Displays JVM classpath information").build());
        this.addOption(Option.builder("mem").longOpt("memory").desc("Displays memory information about current JVM").build());
        this.addOption(new Option("gc", "Performs garbage collection"));
    }

    @Override
    public String execute(String[] args) throws Exception {
        ParsedOptions options = this.parse(args);
        if (options.hasOption("props")) {
            this.printSysProperties();
        } else if (options.hasOption("cp")) {
            this.printClasspath();
        } else if (options.hasOption("mem")) {
            this.mem(false);
        } else if (options.hasOption("gc")) {
            this.mem(true);
        } else {
            this.printUsage();
        }
        return null;
    }

    private void printSysProperties() {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            this.getConsole().writeLine("%1$30s   %2$s", entry.getKey(), entry.getValue());
        }
    }

    private void printClasspath() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        for (String line : StringUtils.split((String)bean.getClassPath(), (String)File.pathSeparator)) {
            this.getConsole().writeLine(line);
        }
    }

    private void mem(boolean gc) {
        long total = Runtime.getRuntime().totalMemory();
        long before = Runtime.getRuntime().freeMemory();
        this.getConsole().setStyle("yellow");
        this.getConsole().write("Total memory: ");
        this.getConsole().setStyle("fg:off");
        this.getConsole().writeLine(StringUtils.convertToHumanFriendlyByteSize((long)total));
        this.getConsole().setStyle("yellow");
        this.getConsole().write("Used memory: ");
        this.getConsole().setStyle("fg:off");
        this.getConsole().writeLine(StringUtils.convertToHumanFriendlyByteSize((long)(total - before)));
        if (gc) {
            System.gc();
            System.gc();
            System.runFinalization();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long after = Runtime.getRuntime().freeMemory();
            this.getConsole().setStyle("yellow");
            this.getConsole().write("Free memory before GC: ");
            this.getConsole().setStyle("fg:off");
            this.getConsole().writeLine(StringUtils.convertToHumanFriendlyByteSize((long)before));
            this.getConsole().setStyle("yellow");
            this.getConsole().write("Free memory after GC: ");
            this.getConsole().setStyle("fg:off");
            this.getConsole().writeLine(StringUtils.convertToHumanFriendlyByteSize((long)after));
            this.getConsole().setStyle("yellow");
            this.getConsole().write("Memory gained with GC: ");
            this.getConsole().setStyle("fg:off");
            this.getConsole().writeLine(StringUtils.convertToHumanFriendlyByteSize((long)(after - before)));
        } else {
            this.getConsole().setStyle("yellow");
            this.getConsole().write("Free memory: ");
            this.getConsole().setStyle("fg:off");
            this.getConsole().writeLine(StringUtils.convertToHumanFriendlyByteSize((long)before));
        }
        this.getConsole().offStyle();
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return SysInfoCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return SysInfoCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Displays current JVM runtime information";
        }

        @Override
        public String getUsage() {
            return null;
        }

        @Override
        public Collection<Option> getOptions() {
            return SysInfoCommand.this.options.getOptions();
        }
    }
}

