/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtin;

import com.aspectran.core.component.translet.TransletNotFoundException;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandLineParser;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import java.util.Collection;

public class TransletCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtin";
    private static final String COMMAND_NAME = "translet";
    private CommandDescriptor descriptor = new CommandDescriptor();

    public TransletCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("l").longOpt("list").desc("Prints all translets or those filtered by the given name").build());
        this.addOption(Option.builder("h").longOpt("help").desc("Display this help").build());
    }

    @Override
    public String execute(String[] args) throws Exception {
        ParsedOptions options = this.parse(args);
        if (!options.hasOptions() && options.hasArgs()) {
            String commandLine = String.join((CharSequence)" ", options.getArgs());
            CommandLineParser parser = CommandLineParser.parseCommandLine(commandLine);
            try {
                this.getService().execute(parser);
            }
            catch (TransletNotFoundException e) {
                this.getConsole().writeLine("No translet mapped to '" + parser.getCommand() + "'");
            }
            this.getConsole().writeLine();
        } else if (options.hasOption("l")) {
            String[] keywords = options.getArgs();
            this.listTranslets((String[])(keywords.length > 0 ? keywords : null));
        } else {
            this.printUsage();
        }
        return null;
    }

    private void listTranslets(String[] keywords) {
        TransletRuleRegistry transletRuleRegistry = this.getService().getActivityContext().getTransletRuleRegistry();
        Collection transletRules = transletRuleRegistry.getTransletRules();
        for (TransletRule transletRule : transletRules) {
            String name = transletRule.getName();
            if (!this.getService().isExposable(name)) continue;
            if (keywords != null) {
                boolean exists = false;
                for (String keyw : keywords) {
                    if (!name.contains(keyw)) continue;
                    exists = true;
                }
                if (!exists) continue;
            }
            if (transletRule.getAllowedMethods() != null) {
                this.getConsole().write("[");
                for (int i = 0; i < transletRule.getAllowedMethods().length; ++i) {
                    if (i > 0) {
                        this.getConsole().write(", ");
                    }
                    this.getConsole().write(transletRule.getAllowedMethods()[i].toString());
                }
                this.getConsole().writeLine("] ");
            }
            this.getConsole().writeLine(name);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return TransletCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return TransletCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Translet run, or you can find them";
        }

        @Override
        public String getUsage() {
            return "translet [-l] [translet_name]";
        }

        @Override
        public Collection<Option> getOptions() {
            return TransletCommand.this.options.getOptions();
        }
    }
}

