/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtin;

import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import java.util.Collection;

public class VerboseCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(VerboseCommand.class);
    private static final String NAMESPACE = "builtin";
    private static final String COMMAND_NAME = "verbose";
    private CommandDescriptor descriptor = new CommandDescriptor();

    public VerboseCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(new Option("on", "Enable verbose output"));
        this.addOption(new Option("off", "Disable verbose output"));
        this.addOption(Option.builder("h").longOpt("help").desc("Display this help").build());
    }

    @Override
    public String execute(String[] args) throws Exception {
        ParsedOptions options = this.parse(args);
        if (options.hasOption("on")) {
            this.getService().setVerbose(true);
            this.getConsole().writeLine("Enabled verbose mode");
        } else if (options.hasOption("off")) {
            this.getService().setVerbose(false);
            this.getConsole().writeLine("Disabled verbose mode");
        } else {
            this.printUsage();
        }
        return null;
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return VerboseCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return VerboseCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Turns verbose mode on or off";
        }

        @Override
        public String getUsage() {
            return "verbose [-h|--help] [-on] [-off]";
        }

        @Override
        public Collection<Option> getOptions() {
            return VerboseCommand.this.options.getOptions();
        }
    }
}

