/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.shell.command.option.AlreadySelectedException;
import com.aspectran.shell.command.option.AmbiguousOptionException;
import com.aspectran.shell.command.option.MissingArgumentException;
import com.aspectran.shell.command.option.MissingOptionException;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionGroup;
import com.aspectran.shell.command.option.OptionParser;
import com.aspectran.shell.command.option.OptionParserException;
import com.aspectran.shell.command.option.OptionUtils;
import com.aspectran.shell.command.option.Options;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.command.option.UnrecognizedOptionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class DefaultOptionParser
implements OptionParser {
    protected ParsedOptions parsedOptions;
    protected Options options;
    protected boolean stopAtNonOption;
    protected String currentToken;
    protected Option currentOption;
    protected boolean skipParsing;
    protected List<Object> expectedOpts;
    private boolean allowPartialMatching;

    public DefaultOptionParser() {
        this.allowPartialMatching = true;
    }

    public DefaultOptionParser(boolean allowPartialMatching) {
        this.allowPartialMatching = allowPartialMatching;
    }

    @Override
    public ParsedOptions parse(Options options, String[] arguments) throws OptionParserException {
        return this.parse(options, arguments, null);
    }

    @Override
    public ParsedOptions parse(Options options, String[] arguments, Properties properties) throws OptionParserException {
        return this.parse(options, arguments, properties, false);
    }

    @Override
    public ParsedOptions parse(Options options, String[] arguments, boolean stopAtNonOption) throws OptionParserException {
        return this.parse(options, arguments, null, stopAtNonOption);
    }

    @Override
    public ParsedOptions parse(Options options, String[] arguments, Properties properties, boolean stopAtNonOption) throws OptionParserException {
        this.options = options;
        this.stopAtNonOption = stopAtNonOption;
        this.skipParsing = false;
        this.currentOption = null;
        this.expectedOpts = new ArrayList<Object>(options.getRequiredOptions());
        for (OptionGroup group : options.getOptionGroups()) {
            group.setSelected(null);
        }
        this.parsedOptions = new ParsedOptions();
        if (arguments != null) {
            for (String argument : arguments) {
                this.handleToken(argument);
            }
        }
        this.checkRequiredArgs();
        this.handleProperties(properties);
        this.checkRequiredOptions();
        return this.parsedOptions;
    }

    private void handleProperties(Properties properties) throws OptionParserException {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            boolean selected;
            String option = e.nextElement().toString();
            Option opt = this.options.getOption(option);
            if (opt == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", option);
            }
            OptionGroup group = this.options.getOptionGroup(opt);
            boolean bl = selected = group != null && group.getSelected() != null;
            if (this.parsedOptions.hasOption(option) || selected) continue;
            String value = properties.getProperty(option);
            if (opt.hasArg()) {
                if (opt.getValues() == null || opt.getValues().length == 0) {
                    opt.addValueForProcessing(value);
                }
            } else if (!"yes".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value) && !"1".equalsIgnoreCase(value)) continue;
            this.handleOption(opt);
            this.currentOption = null;
        }
    }

    protected void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private void checkRequiredArgs() throws OptionParserException {
        if (this.currentOption != null && this.currentOption.requiresArg()) {
            throw new MissingArgumentException(this.currentOption);
        }
    }

    private void handleToken(String token) throws OptionParserException {
        this.currentToken = token;
        if (this.skipParsing) {
            this.parsedOptions.addArg(token);
        } else if ("--".equals(token)) {
            this.skipParsing = true;
        } else if (this.currentOption != null && this.currentOption.acceptsArg() && this.isArgument(token)) {
            this.currentOption.addValueForProcessing(OptionUtils.stripLeadingAndTrailingQuotes(token));
        } else if (token.startsWith("--")) {
            this.handleLongOption(token);
        } else if (token.startsWith("-") && token.length() > 1) {
            this.handleShortAndLongOption(token);
        } else {
            this.handleUnknownToken(token);
        }
        if (this.currentOption != null && !this.currentOption.acceptsArg()) {
            this.currentOption = null;
        }
    }

    private boolean isArgument(String token) {
        return !this.isOption(token) || this.isNegativeNumber(token);
    }

    private boolean isNegativeNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isOption(String token) {
        return this.isLongOption(token) || this.isShortOption(token);
    }

    private boolean isShortOption(String token) {
        String optName;
        if (!token.startsWith("-") || token.length() == 1) {
            return false;
        }
        int pos = token.indexOf("=");
        String string = optName = pos == -1 ? token.substring(1) : token.substring(1, pos);
        if (this.options.hasShortOption(optName)) {
            return true;
        }
        return optName.length() > 0 && this.options.hasShortOption(String.valueOf(optName.charAt(0)));
    }

    private boolean isLongOption(String token) {
        String t;
        if (!token.startsWith("-") || token.length() == 1) {
            return false;
        }
        int pos = token.indexOf("=");
        String string = t = pos == -1 ? token : token.substring(0, pos);
        if (!this.getMatchingLongOptions(t).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(token) != null && !token.startsWith("--");
    }

    private void handleUnknownToken(String token) throws OptionParserException {
        if (token.startsWith("-") && token.length() > 1 && !this.stopAtNonOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + token, token);
        }
        this.parsedOptions.addArg(token);
        if (this.stopAtNonOption) {
            this.skipParsing = true;
        }
    }

    private void handleLongOption(String token) throws OptionParserException {
        if (token.indexOf(61) == -1) {
            this.handleLongOptionWithoutEqual(token);
        } else {
            this.handleLongOptionWithEqual(token);
        }
    }

    private void handleLongOptionWithoutEqual(String token) throws OptionParserException {
        List<String> matchingOpts = this.getMatchingLongOptions(token);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(token)) {
                throw new AmbiguousOptionException(token, matchingOpts);
            }
            String key = this.options.hasLongOption(token) ? token : matchingOpts.get(0);
            this.handleOption(this.options.getOption(key));
        }
    }

    private void handleLongOptionWithEqual(String token) throws OptionParserException {
        int pos = token.indexOf(61);
        String value = token.substring(pos + 1);
        String opt = token.substring(0, pos);
        List<String> matchingOpts = this.getMatchingLongOptions(opt);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(opt)) {
                throw new AmbiguousOptionException(opt, matchingOpts);
            }
            String key = this.options.hasLongOption(opt) ? opt : matchingOpts.get(0);
            Option option = this.options.getOption(key);
            if (option.acceptsArg()) {
                this.handleOption(option);
                this.currentOption.addValueForProcessing(value);
                this.currentOption = null;
            } else {
                this.handleUnknownToken(this.currentToken);
            }
        }
    }

    private void handleShortAndLongOption(String token) throws OptionParserException {
        String t = OptionUtils.stripLeadingHyphens(token);
        int pos = t.indexOf(61);
        if (t.length() == 1) {
            if (this.options.hasShortOption(t)) {
                this.handleOption(this.options.getOption(t));
            } else {
                this.handleUnknownToken(token);
            }
        } else if (pos == -1) {
            if (this.options.hasShortOption(t)) {
                this.handleOption(this.options.getOption(t));
            } else if (!this.getMatchingLongOptions(t).isEmpty()) {
                this.handleLongOptionWithoutEqual(token);
            } else {
                String opt = this.getLongPrefix(t);
                if (opt != null && this.options.getOption(opt).acceptsArg()) {
                    this.handleOption(this.options.getOption(opt));
                    this.currentOption.addValueForProcessing(t.substring(opt.length()));
                    this.currentOption = null;
                } else if (this.isJavaProperty(t)) {
                    this.handleOption(this.options.getOption(t.substring(0, 1)));
                    this.currentOption.addValueForProcessing(t.substring(1));
                    this.currentOption = null;
                } else {
                    this.handleConcatenatedOptions(token);
                }
            }
        } else {
            String opt = t.substring(0, pos);
            String value = t.substring(pos + 1);
            if (opt.length() == 1) {
                Option option = this.options.getOption(opt);
                if (option != null && option.acceptsArg()) {
                    this.handleOption(option);
                    this.currentOption.addValueForProcessing(value);
                    this.currentOption = null;
                } else {
                    this.handleUnknownToken(token);
                }
            } else if (this.isJavaProperty(opt)) {
                this.handleOption(this.options.getOption(opt.substring(0, 1)));
                this.currentOption.addValueForProcessing(opt.substring(1));
                this.currentOption.addValueForProcessing(value);
                this.currentOption = null;
            } else {
                this.handleLongOptionWithEqual(token);
            }
        }
    }

    private String getLongPrefix(String token) {
        String t = OptionUtils.stripLeadingHyphens(token);
        String opt = null;
        for (int i = t.length() - 2; i > 1; --i) {
            String prefix = t.substring(0, i);
            if (!this.options.hasLongOption(prefix)) continue;
            opt = prefix;
            break;
        }
        return opt;
    }

    private boolean isJavaProperty(String token) {
        String opt = token.substring(0, 1);
        Option option = this.options.getOption(opt);
        return option != null && (option.getArgs() >= 2 || option.getArgs() == -2);
    }

    private void handleOption(Option option) throws OptionParserException {
        this.checkRequiredArgs();
        option = option.clone();
        this.updateRequiredOptions(option);
        this.parsedOptions.addOption(option);
        this.currentOption = option.hasArg() ? option : null;
    }

    private void updateRequiredOptions(Option option) throws AlreadySelectedException {
        if (option.isRequired()) {
            this.expectedOpts.remove(option.getKey());
        }
        if (this.options.getOptionGroup(option) != null) {
            OptionGroup group = this.options.getOptionGroup(option);
            if (group.isRequired()) {
                this.expectedOpts.remove(group);
            }
            group.setSelected(option);
        }
    }

    private List<String> getMatchingLongOptions(String token) {
        if (this.allowPartialMatching) {
            return this.options.getMatchingOptions(token);
        }
        ArrayList<String> matches = new ArrayList<String>(1);
        if (this.options.hasLongOption(token)) {
            Option option = this.options.getOption(token);
            matches.add(option.getLongOpt());
        }
        return matches;
    }

    protected void handleConcatenatedOptions(String token) throws OptionParserException {
        for (int i = 1; i < token.length(); ++i) {
            String ch = String.valueOf(token.charAt(i));
            if (this.options.hasOption(ch)) {
                this.handleOption(this.options.getOption(ch));
                if (this.currentOption == null || token.length() == i + 1) continue;
                this.currentOption.addValueForProcessing(token.substring(i + 1));
                break;
            }
            this.handleUnknownToken(this.stopAtNonOption && i > 1 ? token.substring(i) : token);
            break;
        }
    }
}

