/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionGroup;
import com.aspectran.shell.command.option.OptionUtils;
import com.aspectran.shell.command.option.Options;
import com.aspectran.shell.console.Console;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 3;
    public static final int DEFAULT_DESC_PAD = 3;
    private static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    private static final String DEFAULT_OPT_PREFIX = "-";
    private static final String DEFAULT_LONG_OPT_PREFIX = "--";
    private static final String DEFAULT_LONG_OPT_SEPARATOR = " ";
    private static final String DEFAULT_ARG_NAME = "arg";
    private int defaultWidth = 74;
    private int defaultLeftPad = 3;
    private int defaultDescPad = 3;
    private String defaultSyntaxPrefix = "usage: ";
    private String defaultNewLine = System.getProperty("line.separator");
    private String defaultOptPrefix = "-";
    private String defaultLongOptPrefix = "--";
    private String defaultArgName = "arg";
    protected Comparator<Option> optionComparator = new OptionComparator();
    private String longOptSeparator = " ";
    private final Console console;

    public HelpFormatter(Console console) {
        this.console = console;
    }

    public void setWidth(int width) {
        this.defaultWidth = width;
    }

    public int getWidth() {
        return this.defaultWidth;
    }

    public void setLeftPadding(int padding) {
        this.defaultLeftPad = padding;
    }

    public int getLeftPadding() {
        return this.defaultLeftPad;
    }

    public void setDescPadding(int padding) {
        this.defaultDescPad = padding;
    }

    public int getDescPadding() {
        return this.defaultDescPad;
    }

    public void setSyntaxPrefix(String prefix) {
        this.defaultSyntaxPrefix = prefix;
    }

    public String getSyntaxPrefix() {
        return this.defaultSyntaxPrefix;
    }

    public void setNewLine(String newline) {
        this.defaultNewLine = newline;
    }

    public String getNewLine() {
        return this.defaultNewLine;
    }

    public void setOptPrefix(String prefix) {
        this.defaultOptPrefix = prefix;
    }

    public String getOptPrefix() {
        return this.defaultOptPrefix;
    }

    public void setLongOptPrefix(String prefix) {
        this.defaultLongOptPrefix = prefix;
    }

    public String getLongOptPrefix() {
        return this.defaultLongOptPrefix;
    }

    public void setLongOptSeparator(String longOptSeparator) {
        this.longOptSeparator = longOptSeparator;
    }

    public String getLongOptSeparator() {
        return this.longOptSeparator;
    }

    public void setArgName(String name) {
        this.defaultArgName = name;
    }

    public String getArgName() {
        return this.defaultArgName;
    }

    public Comparator<Option> getOptionComparator() {
        return this.optionComparator;
    }

    public void setOptionComparator(Comparator<Option> comparator) {
        this.optionComparator = comparator;
    }

    public void printHelp(String cmdLineSyntax, Options options) {
        this.printHelp(this.getWidth(), cmdLineSyntax, null, options, null, false);
    }

    public void printHelp(String cmdLineSyntax, Options options, boolean autoUsage) {
        this.printHelp(this.getWidth(), cmdLineSyntax, null, options, null, autoUsage);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer) {
        this.printHelp(cmdLineSyntax, header, options, footer, false);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        this.printHelp(this.getWidth(), cmdLineSyntax, header, options, footer, autoUsage);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer) {
        this.printHelp(width, cmdLineSyntax, header, options, footer, false);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        this.printHelp(width, cmdLineSyntax, header, options, this.getLeftPadding(), this.getDescPadding(), footer, autoUsage);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer) {
        this.printHelp(width, cmdLineSyntax, header, options, leftPad, descPad, footer, false);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer, boolean autoUsage) {
        if (cmdLineSyntax == null || cmdLineSyntax.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (autoUsage) {
            this.printUsage(width, cmdLineSyntax, options);
        } else {
            this.printUsage(width, cmdLineSyntax);
        }
        if (header != null && header.trim().length() > 0) {
            this.printWrapped(width, header);
        }
        if (!options.isEmpty()) {
            this.printOptions(width, options, leftPad, descPad);
        }
        if (footer != null && footer.trim().length() > 0) {
            this.printWrapped(width, footer);
        }
    }

    public void printUsage(int width, String commandName, Options options) {
        StringBuilder sb = new StringBuilder(this.getSyntaxPrefix()).append(commandName).append(DEFAULT_LONG_OPT_SEPARATOR);
        ArrayList<OptionGroup> processedGroups = new ArrayList<OptionGroup>();
        ArrayList<Option> optList = new ArrayList<Option>(options.getOptions());
        if (optList.size() > 1 && this.getOptionComparator() != null) {
            optList.sort(this.getOptionComparator());
        }
        Iterator it = optList.iterator();
        while (it.hasNext()) {
            Option option = (Option)it.next();
            OptionGroup group = options.getOptionGroup(option);
            if (group != null) {
                if (!processedGroups.contains(group)) {
                    processedGroups.add(group);
                    this.appendOptionGroup(sb, group);
                }
            } else {
                this.appendOption(sb, option, option.isRequired());
            }
            if (!it.hasNext()) continue;
            sb.append(DEFAULT_LONG_OPT_SEPARATOR);
        }
        this.printWrapped(width, sb.toString().indexOf(32) + 1, sb.toString());
    }

    private void appendOptionGroup(StringBuilder sb, OptionGroup group) {
        ArrayList<Option> optList;
        if (!group.isRequired()) {
            sb.append("[");
        }
        if ((optList = new ArrayList<Option>(group.getOptions())).size() > 1 && this.getOptionComparator() != null) {
            optList.sort(this.getOptionComparator());
        }
        Iterator it = optList.iterator();
        while (it.hasNext()) {
            this.appendOption(sb, (Option)it.next(), true);
            if (!it.hasNext()) continue;
            sb.append(" | ");
        }
        if (!group.isRequired()) {
            sb.append("]");
        }
    }

    private void appendOption(StringBuilder sb, Option option, boolean required) {
        if (!required) {
            sb.append("[");
        }
        if (option.getOpt() != null) {
            sb.append(DEFAULT_OPT_PREFIX).append(option.getOpt());
        } else {
            sb.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongOpt());
        }
        if (option.hasArg() && (option.getArgName() == null || option.getArgName().length() != 0)) {
            sb.append(option.getOpt() == null ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
            sb.append("<").append(option.getArgName() != null ? option.getArgName() : this.getArgName()).append(">");
        }
        if (!required) {
            sb.append("]");
        }
    }

    public void printUsage(int width, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        this.printWrapped(width, this.getSyntaxPrefix().length() + argPos, this.getSyntaxPrefix() + cmdLineSyntax);
    }

    public void printOptions(int width, Options options, int leftPad, int descPad) {
        StringBuilder sb = new StringBuilder();
        this.renderOptions(sb, width, options, leftPad, descPad);
        this.console.writeLine(sb.toString());
    }

    public void printWrapped(int width, String text) {
        this.printWrapped(width, 0, text);
    }

    public void printWrapped(int width, int nextLineTabStop, String text) {
        StringBuilder sb = new StringBuilder(text.length());
        this.renderWrappedTextBlock(sb, width, nextLineTabStop, text);
        this.console.writeLine(sb.toString());
    }

    protected StringBuilder renderOptions(StringBuilder sb, int width, Options options, int leftPad, int descPad) {
        String lpad = OptionUtils.createPadding(leftPad);
        String dpad = OptionUtils.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuilder> prefixList = new ArrayList<StringBuilder>();
        List<Option> optList = options.helpOptions();
        if (optList.size() > 1 && this.getOptionComparator() != null) {
            optList.sort(this.getOptionComparator());
        }
        for (Option option : optList) {
            StringBuilder optBuf = new StringBuilder();
            if (option.getOpt() == null) {
                optBuf.append(lpad).append("   ").append(this.getLongOptPrefix()).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.getOptPrefix()).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.getLongOptPrefix()).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                String argName = option.getArgName();
                if (argName != null && argName.length() == 0) {
                    optBuf.append(' ');
                } else {
                    optBuf.append(option.hasLongOpt() ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
                    optBuf.append("<").append(argName != null ? option.getArgName() : this.getArgName()).append(">");
                }
            }
            prefixList.add(optBuf);
            max = optBuf.length() > max ? optBuf.length() : max;
        }
        int x = 0;
        Iterator<Option> it = optList.iterator();
        while (it.hasNext()) {
            StringBuilder optBuf;
            Option option = it.next();
            if ((optBuf = new StringBuilder(((StringBuilder)prefixList.get(x++)).toString())).length() < max) {
                optBuf.append(OptionUtils.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max + descPad;
            if (option.getDescription() != null) {
                optBuf.append(option.getDescription());
            }
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
            if (!it.hasNext()) continue;
            sb.append(this.getNewLine());
        }
        return sb;
    }

    protected StringBuilder renderWrappedText(StringBuilder sb, int width, int nextLineTabStop, String text) {
        int pos = OptionUtils.findWrapPos(text, width, 0);
        if (pos == -1) {
            sb.append(OptionUtils.rtrim(text));
            return sb;
        }
        sb.append(OptionUtils.rtrim(text.substring(0, pos))).append(this.getNewLine());
        if (nextLineTabStop >= width) {
            nextLineTabStop = 1;
        }
        String padding = OptionUtils.createPadding(nextLineTabStop);
        while (true) {
            if ((pos = OptionUtils.findWrapPos(text = padding + text.substring(pos).trim(), width, 0)) == -1) {
                sb.append(text);
                return sb;
            }
            if (text.length() > width && pos == nextLineTabStop - 1) {
                pos = width;
            }
            sb.append(OptionUtils.rtrim(text.substring(0, pos))).append(this.getNewLine());
        }
    }

    private Appendable renderWrappedTextBlock(StringBuilder sb, int width, int nextLineTabStop, String text) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(text));
            boolean firstLine = true;
            while ((line = in.readLine()) != null) {
                if (!firstLine) {
                    sb.append(this.getNewLine());
                } else {
                    firstLine = false;
                }
                this.renderWrappedText(sb, width, nextLineTabStop, line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb;
    }

    private static class OptionComparator
    implements Comparator<Option>,
    Serializable {
        private static final long serialVersionUID = -4277822882012181887L;

        private OptionComparator() {
        }

        @Override
        public int compare(Option opt1, Option opt2) {
            return opt1.getKey().compareToIgnoreCase(opt2.getKey());
        }
    }
}

