/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionParserException;
import com.aspectran.shell.command.option.OptionUtils;
import com.aspectran.shell.command.option.OptionValueType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ParsedOptions
implements Serializable {
    private static final long serialVersionUID = -875791688751934582L;
    private final List<Option> options = new ArrayList<Option>();
    private final List<String> args = new LinkedList<String>();

    protected ParsedOptions() {
    }

    public boolean hasOption(Option opt) {
        return this.options.contains(opt);
    }

    public boolean hasOption(String opt) {
        return this.hasOption(this.resolveOption(opt));
    }

    public boolean hasOption(char opt) {
        return this.hasOption(String.valueOf(opt));
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public <T> T getParsedValue(Option option) throws OptionParserException {
        if (option == null) {
            return null;
        }
        String value = this.getValue(option);
        if (value == null) {
            return null;
        }
        OptionValueType valueType = option.getValueType();
        if (valueType == OptionValueType.STRING) {
            return (T)value;
        }
        if (valueType == OptionValueType.INT) {
            try {
                return (T)Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.LONG) {
            try {
                return (T)Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.FLOAT) {
            try {
                return (T)Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.DOUBLE) {
            try {
                return (T)Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.BOOLEAN) {
            try {
                return (T)Boolean.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.FILE) {
            return (T)new File(value);
        }
        return null;
    }

    public <T> T getParsedValue(String opt) throws OptionParserException {
        return this.getParsedValue(this.resolveOption(opt));
    }

    public <T> T getParsedValue(char opt) throws OptionParserException {
        return this.getParsedValue(String.valueOf(opt));
    }

    public String getValue(Option option) {
        if (option == null) {
            return null;
        }
        String[] values = this.getValues(option);
        return values == null ? null : values[0];
    }

    public String getValue(String opt) {
        return this.getValue(this.resolveOption(opt));
    }

    public String getValue(char opt) {
        return this.getValue(String.valueOf(opt));
    }

    public String[] getValues(Option option) {
        ArrayList<String> values = new ArrayList<String>();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option)) continue;
            values.addAll(processedOption.getValuesList());
        }
        return values.isEmpty() ? null : values.toArray(new String[0]);
    }

    public String[] getValues(String opt) {
        return this.getValues(this.resolveOption(opt));
    }

    private Option resolveOption(String opt) {
        opt = OptionUtils.stripLeadingHyphens(opt);
        for (Option option : this.options) {
            if (opt.equals(option.getOpt())) {
                return option;
            }
            if (!opt.equals(option.getLongOpt())) continue;
            return option;
        }
        return null;
    }

    public String[] getValues(char opt) {
        return this.getValues(String.valueOf(opt));
    }

    public String getValue(Option option, String defaultValue) {
        String answer = this.getValue(option);
        return answer != null ? answer : defaultValue;
    }

    public String getValue(String opt, String defaultValue) {
        return this.getValue(this.resolveOption(opt), defaultValue);
    }

    public String getValue(char opt, String defaultValue) {
        return this.getValue(String.valueOf(opt), defaultValue);
    }

    public Properties getProperties(Option option) {
        Properties props = new Properties();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option)) continue;
            List<String> values = processedOption.getValuesList();
            if (values.size() >= 2) {
                props.put(values.get(0), values.get(1));
                continue;
            }
            if (values.size() != 1) continue;
            props.put(values.get(0), "true");
        }
        return props;
    }

    public Properties getProperties(String opt) {
        Properties props = new Properties();
        for (Option option : this.options) {
            if (!opt.equals(option.getOpt()) && !opt.equals(option.getLongOpt())) continue;
            List<String> values = option.getValuesList();
            if (values.size() >= 2) {
                props.put(values.get(0), values.get(1));
                continue;
            }
            if (values.size() != 1) continue;
            props.put(values.get(0), "true");
        }
        return props;
    }

    protected void addOption(Option opt) {
        this.options.add(opt);
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    public Option[] getOptions() {
        return this.options.toArray(new Option[0]);
    }

    public boolean hasArgs() {
        return !this.args.isEmpty();
    }

    public String[] getArgs() {
        return this.args.toArray(new String[0]);
    }

    public List<String> getArgList() {
        return this.args;
    }

    protected void addArg(String arg) {
        this.args.add(arg);
    }
}

