/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.console;

import com.aspectran.shell.console.AbstractConsole;
import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class DefaultConsole
extends AbstractConsole {
    private boolean reading;

    @Override
    public String readCommandLine() {
        String prompt = this.getCommandPrompt();
        return this.readCommandLine(prompt);
    }

    @Override
    public String readCommandLine(String prompt) {
        try {
            if (System.console() != null) {
                return System.console().readLine(prompt, new Object[0]);
            }
            if (prompt != null) {
                this.write(prompt);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            return reader.readLine();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public String readLine() {
        return this.readLine(null);
    }

    @Override
    public String readLine(String prompt) {
        try {
            this.reading = true;
            if (System.console() != null) {
                String string = System.console().readLine(prompt, new Object[0]);
                return string;
            }
            if (prompt != null) {
                this.write(prompt);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            this.reading = false;
        }
    }

    @Override
    public String readLine(String format, Object ... args) {
        return this.readLine(String.format(format, args));
    }

    @Override
    public String readPassword() {
        return this.readPassword(null);
    }

    @Override
    public String readPassword(String prompt) {
        if (System.console() != null) {
            return new String(System.console().readPassword(prompt, new Object[0]));
        }
        return this.readLine(prompt);
    }

    @Override
    public String readPassword(String format, Object ... args) {
        return this.readPassword(String.format(format, args));
    }

    @Override
    public void write(String string) {
        System.out.print(string);
    }

    @Override
    public void write(String format, Object ... args) {
        System.out.print(String.format(format, args));
    }

    @Override
    public void writeLine(String string) {
        System.out.println(string);
    }

    @Override
    public void writeLine(String format, Object ... args) {
        this.write(format, args);
        System.out.println();
    }

    @Override
    public void writeLine() {
        System.out.println();
    }

    @Override
    public void clearScreen() {
        System.out.print("\u001b[H\u001b[2J");
        System.out.flush();
    }

    @Override
    public void flush() {
        System.out.flush();
    }

    @Override
    public String getEncoding() {
        return Charset.defaultCharset().name();
    }

    @Override
    public OutputStream getOutput() {
        return System.out;
    }

    @Override
    public Writer getWriter() {
        if (System.console() != null) {
            return System.console().writer();
        }
        return new PrintWriter(System.out);
    }

    @Override
    public void setStyle(String ... styles) {
    }

    @Override
    public void offStyle() {
    }

    private String stripStyle() {
        return null;
    }

    @Override
    public boolean isReading() {
        return this.reading;
    }

    @Override
    public boolean confirmRestart() {
        return this.confirmRestart(null);
    }

    @Override
    public boolean confirmRestart(String message) {
        String confirm;
        String yn;
        if (this.isReading()) {
            this.writeLine("Illegal State");
            return false;
        }
        if (message != null) {
            this.writeLine(message);
        }
        return (yn = this.readLine(confirm = "Would you like to restart this shell [Y/n]?")).isEmpty() || yn.equalsIgnoreCase("Y");
    }

    @Override
    public boolean confirmQuit() {
        String confirm = "Are you sure you want to quit [Y/n]?";
        String yn = this.readLine(confirm);
        return yn.isEmpty() || yn.equalsIgnoreCase("Y");
    }
}

