/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.service;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionAgent;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.SessionConfig;
import com.aspectran.core.context.expr.TokenExpressionParser;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.context.rule.type.TokenDirectiveType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.service.AspectranCoreService;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.SystemUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.adapter.ShellApplicationAdapter;
import com.aspectran.shell.adapter.ShellSessionAdapter;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;
import java.io.File;
import java.io.IOException;

public abstract class AbstractShellService
extends AspectranCoreService
implements ShellService {
    private static final Log log = LogFactory.getLog(AbstractShellService.class);
    private SessionManager sessionManager;
    private Console console;
    private String[] commands;
    private CommandRegistry commandRegistry;
    private boolean verbose;
    private String greetings;
    private Token[] greetingsTokens;

    protected AbstractShellService() throws IOException {
        super((ApplicationAdapter)new ShellApplicationAdapter());
        String baseDir = SystemUtils.getProperty((String)"aspectran.baseDir");
        if (baseDir == null) {
            baseDir = new File("").getCanonicalPath();
        }
        this.setBasePath(baseDir);
    }

    public void afterContextLoaded() throws Exception {
        this.sessionManager = new DefaultSessionManager(this.getActivityContext());
        this.sessionManager.setGroupName("SHL");
        SessionConfig sessionConfig = (SessionConfig)this.getAspectranConfig().getParameters(AspectranConfig.session);
        if (sessionConfig != null) {
            this.sessionManager.setSessionConfig(sessionConfig);
        }
        this.sessionManager.initialize();
        if (this.commands != null) {
            CommandRegistry commandRegistry = new CommandRegistry(this);
            commandRegistry.addCommand(this.commands);
            this.setCommandRegistry(commandRegistry);
        }
        this.parseGreetings();
    }

    public void beforeContextDestroy() {
        this.sessionManager.destroy();
        this.sessionManager = null;
    }

    @Override
    public SessionAdapter newSessionAdapter() {
        SessionAgent agent = this.sessionManager.newSessionAgent();
        return new ShellSessionAdapter(agent);
    }

    @Override
    public Console getConsole() {
        return this.console;
    }

    protected void setConsole(Console console) {
        this.console = console;
    }

    @Override
    public String[] getCommands() {
        return this.commands;
    }

    protected void setCommands(String[] commands) {
        this.commands = commands;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    private void setCommandRegistry(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    @Override
    public boolean isExposable(String transletName) {
        return super.isExposable(transletName);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public String getGreetings() {
        return this.greetings;
    }

    @Override
    public void setGreetings(String greetings) {
        this.greetings = greetings;
    }

    @Override
    public void printGreetings() {
        if (this.greetingsTokens != null) {
            TokenExpressionParser evaluator = new TokenExpressionParser((Activity)new InstantActivity(this.getActivityContext()));
            String message = evaluator.evaluateAsString(this.greetingsTokens);
            this.console.writeLine(message);
            this.console.flush();
        } else if (this.greetings != null) {
            this.console.writeLine(this.greetings);
            this.console.flush();
        }
    }

    private void parseGreetings() {
        if (StringUtils.hasText((String)this.greetings)) {
            this.greetingsTokens = TokenParser.makeTokens((String)this.greetings, (boolean)true);
            if (this.greetingsTokens != null) {
                try {
                    for (Token token : this.greetingsTokens) {
                        if (token.getType() != TokenType.BEAN || token.getDirectiveType() != TokenDirectiveType.CLASS) continue;
                        Class beanClass = this.getAspectranClassLoader().loadClass(token.getValue());
                        token.setAlternativeValue((Object)beanClass);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.greetingsTokens = null;
                    log.error("Failed to parse greetings", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void printHelp() {
        if (this.isVerbose() && this.getActivityContext().getDescription() != null) {
            this.console.writeLine(this.getActivityContext().getDescription());
            this.console.flush();
        }
    }

    public void restart() throws Exception {
        super.restart();
    }

    public void restart(String message) throws Exception {
        if (this.console.confirmRestart(message)) {
            super.restart(message);
        }
    }

    public boolean isBusy() {
        return this.console.isReading();
    }
}

