/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.component.translet.TransletNotFoundException;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.ExposalsConfig;
import com.aspectran.core.context.config.ShellConfig;
import com.aspectran.core.context.resource.AspectranClassLoader;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ResourceUtils;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.activity.ShellActivity;
import com.aspectran.shell.command.CommandLineParser;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.console.DefaultConsole;
import com.aspectran.shell.service.AbstractShellService;
import com.aspectran.shell.service.ShellService;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

class AspectranShellService
extends AbstractShellService {
    private static final Log log = LogFactory.getLog(AspectranShellService.class);
    private static final String DEFAULT_ROOT_CONTEXT = "/config/aspectran/root-config.xml";
    private long pauseTimeout = -1L;

    private AspectranShellService() throws IOException {
    }

    @Override
    public void execute(String command) {
        CommandLineParser commandLineParser = CommandLineParser.parseCommandLine(command);
        this.execute(commandLineParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLineParser commandLineParser) {
        if (!this.isExposable(commandLineParser.getCommand())) {
            this.getConsole().writeLine("Unexposable translet: " + commandLineParser.getCommand());
            return;
        }
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (this.pauseTimeout == -1L) {
                    this.getConsole().writeLine(this.getServiceName() + " has been paused");
                } else {
                    long remains = this.pauseTimeout - System.currentTimeMillis();
                    if (remains > 0L) {
                        this.getConsole().writeLine(this.getServiceName() + " has been paused and will resume after " + remains + " ms");
                    } else {
                        this.getConsole().writeLine(this.getServiceName() + " has been paused and will soon resume");
                    }
                }
                return;
            }
            this.pauseTimeout = 0L;
        }
        Writer[] redirectionWriters = null;
        if (commandLineParser.getRedirectionList() != null) {
            try {
                redirectionWriters = commandLineParser.getRedirectionWriters(this.getConsole());
            }
            catch (Exception e) {
                this.getConsole().writeLine("Invalid Redirection: " + CommandLineParser.serialize(commandLineParser.getRedirectionList()), e);
                return;
            }
        }
        ShellActivity activity = null;
        try {
            activity = new ShellActivity(this, redirectionWriters);
            activity.prepare(commandLineParser.getCommand(), commandLineParser.getRequestMethod());
            activity.perform();
        }
        catch (TransletNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("Unknown translet: " + commandLineParser.getCommand());
            }
            throw e;
        }
        catch (ActivityTerminatedException e) {
            if (log.isDebugEnabled()) {
                log.debug("Activity terminated: Cause: " + e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("An error occurred while processing the command", (Throwable)e);
        }
        finally {
            if (redirectionWriters != null) {
                for (Writer writer : redirectionWriters) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        log.error("Redirection writer close failed: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (activity != null) {
                activity.finish();
            }
        }
    }

    protected static ShellService create(String aspectranConfigFile) throws AspectranServiceException, IOException {
        return AspectranShellService.create(aspectranConfigFile, null);
    }

    protected static ShellService create(String aspectranConfigFile, Console console) throws AspectranServiceException, IOException {
        File file = ResourceUtils.getFile((String)aspectranConfigFile, (ClassLoader)AspectranClassLoader.getDefaultClassLoader());
        return AspectranShellService.create(file, console);
    }

    protected static ShellService create(File aspectranConfigFile) throws AspectranServiceException, IOException {
        return AspectranShellService.create(aspectranConfigFile, null);
    }

    protected static ShellService create(File aspectranConfigFile, Console console) throws AspectranServiceException, IOException {
        ContextConfig contextConfig;
        String rootConfigLocation;
        AspectranConfig aspectranConfig = new AspectranConfig();
        if (aspectranConfigFile != null) {
            try {
                AponReader.parse((File)aspectranConfigFile, (Parameters)aspectranConfig);
            }
            catch (Exception e) {
                throw new AspectranServiceException("Failed to parse aspectran config file: " + aspectranConfigFile, (Throwable)e);
            }
        }
        if ((rootConfigLocation = (contextConfig = aspectranConfig.touchContextConfig()).getString(ContextConfig.root)) == null || rootConfigLocation.length() == 0) {
            contextConfig.putValue(ContextConfig.root, (Object)DEFAULT_ROOT_CONTEXT);
        }
        AspectranShellService service = new AspectranShellService();
        service.prepare(aspectranConfig);
        ShellConfig shellConfig = aspectranConfig.getShellConfig();
        if (shellConfig != null) {
            String[] commands;
            if (console != null) {
                service.setConsole(console);
            } else {
                service.setConsole(new DefaultConsole());
            }
            String commandPrompt = shellConfig.getString(ShellConfig.prompt);
            if (commandPrompt != null) {
                service.getConsole().setCommandPrompt(commandPrompt);
            }
            if ((commands = shellConfig.getStringArray(ShellConfig.commands)) != null && commands.length > 0) {
                service.setCommands(commands);
            }
            service.setVerbose(BooleanUtils.toBoolean((Boolean)shellConfig.getBoolean(ShellConfig.verbose)));
            service.setGreetings(shellConfig.getString(ShellConfig.greetings));
            ExposalsConfig exposalsConfig = shellConfig.getExposalsConfig();
            if (exposalsConfig != null) {
                String[] includePatterns = exposalsConfig.getStringArray(ExposalsConfig.plus);
                String[] excludePatterns = exposalsConfig.getStringArray(ExposalsConfig.minus);
                service.setExposals(includePatterns, excludePatterns);
            }
        } else {
            service.setConsole(new DefaultConsole());
        }
        AspectranShellService.setServiceStateListener(service);
        return service;
    }

    private static void setServiceStateListener(final AspectranShellService service) {
        service.setServiceStateListener(new ServiceStateListener(){

            public void started() {
                service.pauseTimeout = 0L;
                service.printGreetings();
                service.printHelp();
            }

            public void restarted() {
                this.started();
            }

            public void paused(long millis) {
                if (millis < 0L) {
                    throw new IllegalArgumentException("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
                service.pauseTimeout = System.currentTimeMillis() + millis;
            }

            public void paused() {
                service.pauseTimeout = -1L;
            }

            public void resumed() {
                service.pauseTimeout = 0L;
            }

            public void stopped() {
                this.paused();
            }
        });
    }
}

