/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.service;

import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.SystemUtils;
import com.aspectran.shell.command.CommandLineParser;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.AspectranShellService;
import java.io.File;
import java.io.IOException;

public interface ShellService
extends CoreService {
    public SessionAdapter newSessionAdapter();

    public Console getConsole();

    public String[] getCommands();

    public CommandRegistry getCommandRegistry();

    public boolean isVerbose();

    public void setVerbose(boolean var1);

    public String getGreetings();

    public void setGreetings(String var1);

    public void printGreetings();

    public void printHelp();

    public boolean isExposable(String var1);

    public void execute(String var1);

    public void execute(CommandLineParser var1);

    public static ShellService create(String aspectranConfigFile) throws AspectranServiceException, IOException {
        return AspectranShellService.create(aspectranConfigFile);
    }

    public static ShellService create(String aspectranConfigFile, Console console) throws AspectranServiceException, IOException {
        return AspectranShellService.create(aspectranConfigFile, console);
    }

    public static ShellService create(File aspectranConfigFile) throws AspectranServiceException, IOException {
        return AspectranShellService.create(aspectranConfigFile);
    }

    public static ShellService create(File aspectranConfigFile, Console console) throws AspectranServiceException, IOException {
        return AspectranShellService.create(aspectranConfigFile, console);
    }

    public static File determineAspectranConfigFile(String arg) {
        String baseDir;
        File file = !StringUtils.isEmpty((String)arg) ? new File(arg) : ((baseDir = SystemUtils.getProperty((String)"aspectran.baseDir")) != null ? new File(baseDir, "aspectran-config.apon") : new File("aspectran-config.apon"));
        return file;
    }
}

