/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell;

import com.aspectran.core.context.InsufficientEnvironmentException;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.util.Aspectran;
import com.aspectran.core.util.ExceptionUtils;
import com.aspectran.shell.command.ShellCommandInterpreter;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.console.DefaultConsole;
import java.io.File;
import java.io.PrintStream;

public class AspectranShell {
    public static void main(String[] args) {
        String basePath = AspectranConfig.determineBasePath((String[])args);
        File aspectranConfigFile = AspectranConfig.determineAspectranConfigFile((String[])args);
        DefaultConsole console = new DefaultConsole();
        AspectranShell.bootstrap(basePath, aspectranConfigFile, console);
    }

    public static void bootstrap(File aspectranConfigFile, Console console) {
        AspectranShell.bootstrap(null, aspectranConfigFile, console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bootstrap(String basePath, File aspectranConfigFile, Console console) {
        if (aspectranConfigFile == null) {
            throw new IllegalArgumentException("aspectranConfigFile must not be null");
        }
        if (console == null) {
            throw new IllegalArgumentException("console must not be null");
        }
        ShellCommandInterpreter interpreter = null;
        int exitStatus = 0;
        try {
            Aspectran.printPrettyAboutMe((PrintStream)System.out);
            interpreter = new ShellCommandInterpreter(console);
            interpreter.init(basePath, aspectranConfigFile);
            interpreter.perform();
        }
        catch (Exception e) {
            Throwable t = ExceptionUtils.getRootCause((Throwable)e);
            if (t instanceof InsufficientEnvironmentException) {
                System.err.println(((InsufficientEnvironmentException)t).getPrettyMessage());
            } else {
                e.printStackTrace(System.err);
            }
            exitStatus = 1;
        }
        finally {
            if (interpreter != null) {
                interpreter.release();
            }
        }
        System.exit(exitStatus);
    }
}

