/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleList;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.StringOutputWriter;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.adapter.ShellRequestAdapter;
import com.aspectran.shell.adapter.ShellResponseAdapter;
import com.aspectran.shell.command.ConsoleTerminatedException;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ShellActivity
extends CoreActivity {
    private static final Log log = LogFactory.getLog(ShellActivity.class);
    private final ShellService service;
    private final Console console;
    private boolean procedural;
    private ParameterMap parameterMap;
    private Writer outputWriter;
    private boolean simpleInputMode;

    public ShellActivity(ShellService service, Console console) {
        super(service.getActivityContext());
        this.service = service;
        this.console = console;
    }

    public void setProcedural(boolean procedural) {
        this.procedural = procedural;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public void setOutputWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    protected void adapt() throws AdapterException {
        try {
            this.setSessionAdapter(this.service.newSessionAdapter());
            ShellRequestAdapter requestAdapter = new ShellRequestAdapter();
            if (this.parameterMap != null) {
                requestAdapter.setParameterMap(this.parameterMap);
            }
            requestAdapter.setEncoding(this.console.getEncoding());
            this.setRequestAdapter((RequestAdapter)requestAdapter);
            if (this.outputWriter == null) {
                this.outputWriter = new StringOutputWriter();
            }
            ShellResponseAdapter responseAdapter = new ShellResponseAdapter(this.outputWriter);
            responseAdapter.setEncoding(this.console.getEncoding());
            this.setResponseAdapter((ResponseAdapter)responseAdapter);
            super.adapt();
        }
        catch (Exception e) {
            throw new AdapterException("Failed to prepare adapters required for shell service activity", (Throwable)e);
        }
    }

    protected void parseRequest() {
        this.showDescription();
        this.readParameters();
        this.parseDeclaredParameters();
        this.readAttributes();
        this.parseDeclaredAttributes();
    }

    private void showDescription() {
        String description;
        if (this.service.isVerbose() && (description = this.getTranslet().getDescription()) != null) {
            this.console.writeLine(description);
        }
    }

    private boolean isSimpleItemRules(ItemRuleList itemRuleList) {
        for (ItemRule itemRule : itemRuleList) {
            if (itemRule.getType() != ItemType.SINGLE) {
                return false;
            }
            Token[] tokens = itemRule.getAllTokens();
            if (tokens == null || tokens.length <= 0) continue;
            if (tokens.length == 1) {
                Token t = tokens[0];
                if (t.getType() != TokenType.PARAMETER) {
                    return false;
                }
                if (!itemRule.getName().equals(t.getName())) {
                    return false;
                }
                if (itemRule.getDefaultValue() == null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void determineSimpleMode(ItemRuleList itemRuleList) {
        this.simpleInputMode = this.isSimpleItemRules(itemRuleList);
    }

    private void readParameters() {
        ItemRuleMap parameterItemRuleMap = this.getRequestRule().getParameterItemRuleMap();
        if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
            ItemRuleList parameterItemRuleList = new ItemRuleList(parameterItemRuleMap.values());
            this.determineSimpleMode(parameterItemRuleList);
            if (this.procedural) {
                this.console.setStyle("GREEN");
                this.console.writeLine("Required parameters:");
                this.console.styleOff();
                if (!this.simpleInputMode) {
                    for (ItemRule itemRule : parameterItemRuleList) {
                        Token[] tokens = itemRule.getAllTokens();
                        if (tokens == null) {
                            Token t = new Token(TokenType.PARAMETER, itemRule.getName());
                            t.setDefaultValue(itemRule.getDefaultValue());
                            tokens = new Token[]{t};
                        }
                        String mandatoryMarker = itemRule.isMandatory() ? " * " : "   ";
                        this.console.setStyle("YELLOW");
                        this.console.write(mandatoryMarker);
                        this.console.styleOff();
                        this.console.setStyle("bold");
                        this.console.write(itemRule.getName());
                        this.console.styleOff();
                        this.console.write(": ");
                        this.writeToken(tokens);
                        this.console.writeLine();
                    }
                }
            }
            this.readRequiredParameters(parameterItemRuleList);
        }
    }

    private void readRequiredParameters(ItemRuleList parameterItemRuleList) {
        ItemRuleList missingItemRules1 = this.procedural ? (this.simpleInputMode ? this.readEachParameter(parameterItemRuleList) : this.readEachToken(parameterItemRuleList)) : this.checkRequiredParameters(parameterItemRuleList);
        if (missingItemRules1 != null) {
            this.console.setStyle("YELLOW");
            this.console.writeLine("Required parameters are missing.");
            this.console.styleOff();
            ItemRuleList missingItemRules2 = this.simpleInputMode ? this.readEachParameter(missingItemRules1) : this.readEachToken(missingItemRules1);
            if (missingItemRules2 != null) {
                String[] itemNames = missingItemRules2.getItemNames();
                this.console.setStyle("RED");
                this.console.writeLine("Missing required parameters:");
                this.console.setStyle("bold");
                for (String name : itemNames) {
                    this.console.writeLine("   %s", name);
                }
                this.console.styleOff();
                this.terminate("Required parameters are missing");
            }
        }
    }

    private void readAttributes() {
        ItemRuleMap attributeItemRuleMap = this.getRequestRule().getAttributeItemRuleMap();
        if (attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
            ItemRuleList attributeItemRuleList = new ItemRuleList(attributeItemRuleMap.values());
            this.determineSimpleMode(attributeItemRuleList);
            if (this.procedural) {
                this.console.setStyle("GREEN");
                this.console.writeLine("Required attributes:");
                this.console.styleOff();
                if (!this.simpleInputMode) {
                    for (ItemRule itemRule : attributeItemRuleList) {
                        Token[] tokens = itemRule.getAllTokens();
                        if (tokens == null) {
                            Token t = new Token(TokenType.PARAMETER, itemRule.getName());
                            t.setDefaultValue(itemRule.getDefaultValue());
                            tokens = new Token[]{t};
                        }
                        String mandatoryMarker = itemRule.isMandatory() ? " * " : "   ";
                        this.console.setStyle("YELLOW");
                        this.console.write(mandatoryMarker);
                        this.console.styleOff();
                        this.console.setStyle("bold");
                        this.console.write(itemRule.getName());
                        this.console.styleOff();
                        this.console.write(": ");
                        this.writeToken(tokens);
                        this.console.writeLine();
                    }
                }
            }
            this.readRequiredAttributes(attributeItemRuleList);
        }
    }

    private void readRequiredAttributes(ItemRuleList attributeItemRuleList) {
        ItemRuleList missingItemRules1 = this.procedural ? (this.simpleInputMode ? this.readEachAttribute(attributeItemRuleList) : this.readEachToken(attributeItemRuleList)) : this.checkRequiredAttributes(attributeItemRuleList);
        if (missingItemRules1 != null) {
            this.console.setStyle("YELLOW");
            this.console.writeLine("Required attributes are missing.");
            this.console.styleOff();
            ItemRuleList missingItemRules2 = this.simpleInputMode ? this.readEachParameter(missingItemRules1) : this.readEachToken(missingItemRules1);
            if (missingItemRules2 != null) {
                String[] itemNames = missingItemRules2.getItemNames();
                this.console.setStyle("RED");
                this.console.writeLine("Missing required attributes:");
                this.console.setStyle("bold");
                for (String name : itemNames) {
                    this.console.writeLine("   %s", name);
                }
                this.console.styleOff();
                this.terminate("Required attributes are missing");
            }
        }
    }

    private ItemRuleList readEachParameter(ItemRuleList itemRuleList) {
        LinkedHashSet<ItemRule> missingItemRules = new LinkedHashSet<ItemRule>();
        try {
            for (ItemRule ir : itemRuleList) {
                String value = this.readParameter(ir);
                if (!StringUtils.isEmpty((String)value)) {
                    this.getRequestAdapter().setParameter(ir.getName(), value);
                    continue;
                }
                if (!ir.isMandatory()) continue;
                missingItemRules.add(ir);
            }
        }
        catch (ConsoleTerminatedException e) {
            log.info("User interrupt occurred");
            this.terminate("User interrupt occurred");
        }
        return missingItemRules.isEmpty() ? null : new ItemRuleList(missingItemRules);
    }

    private ItemRuleList readEachAttribute(ItemRuleList itemRuleList) {
        LinkedHashSet<ItemRule> missingItemRules = new LinkedHashSet<ItemRule>();
        try {
            for (ItemRule ir : itemRuleList) {
                String value = this.readParameter(ir);
                if (!StringUtils.isEmpty((String)value)) {
                    this.getRequestAdapter().setAttribute(ir.getName(), (Object)value);
                    continue;
                }
                if (!ir.isMandatory()) continue;
                missingItemRules.add(ir);
            }
        }
        catch (ConsoleTerminatedException e) {
            log.info("User interrupt occurred");
            this.terminate("User interrupt occurred");
        }
        return missingItemRules.isEmpty() ? null : new ItemRuleList(missingItemRules);
    }

    private String readParameter(ItemRule itemRule) {
        String mandatoryMarker = itemRule.isMandatory() ? " * " : "   ";
        this.console.setStyle("YELLOW");
        this.console.write(mandatoryMarker);
        this.console.styleOff();
        this.console.setStyle("bold");
        this.console.write(itemRule.getName());
        this.console.styleOff();
        if (itemRule.isSecret()) {
            return this.console.readPassword(": ");
        }
        return this.console.readLine(": ");
    }

    private ItemRuleList readEachToken(ItemRuleList itemRuleList) {
        this.console.setStyle("GREEN");
        this.console.writeLine("Enter a value for each token:");
        this.console.styleOff();
        LinkedHashSet<ItemRule> missingItemRules = new LinkedHashSet<ItemRule>();
        try {
            LinkedHashMap inputTokens = new LinkedHashMap();
            for (ItemRule itemRule : itemRuleList) {
                Token[] tokens = itemRule.getAllTokens();
                if (tokens == null || tokens.length == 0) {
                    Token[] t = new Token(TokenType.PARAMETER, itemRule.getName());
                    t.setDefaultValue(itemRule.getDefaultValue());
                    tokens = new Token[]{t};
                }
                for (Token t1 : tokens) {
                    Set<ItemRule> rules;
                    if (t1.getType() != TokenType.PARAMETER) continue;
                    boolean exists = false;
                    for (Token t2 : inputTokens.keySet()) {
                        if (!t2.equals((Object)t1)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        rules = (Set)inputTokens.get(t1);
                        rules.add(itemRule);
                        continue;
                    }
                    rules = new LinkedHashSet();
                    rules.add(itemRule);
                    inputTokens.put(t1, rules);
                }
            }
            for (Map.Entry entry : inputTokens.entrySet()) {
                Token token = (Token)entry.getKey();
                String value = this.getRequestAdapter().getParameter(token.getName());
                if (value != null) {
                    this.console.write("   ");
                    this.writeToken(token);
                    this.console.write(": ");
                    this.console.writeLine(value);
                    continue;
                }
                Set rules = (Set)entry.getValue();
                boolean secret = false;
                for (ItemRule ir : rules) {
                    if (!ir.isSecret()) continue;
                    secret = true;
                    break;
                }
                this.console.write("   ");
                this.writeToken(token);
                value = secret ? this.console.readPassword(": ") : this.console.readLine(": ");
                if (StringUtils.isEmpty((String)value)) {
                    value = token.getDefaultValue();
                }
                if (!StringUtils.isEmpty((String)value)) {
                    this.getRequestAdapter().setParameter(token.getName(), value);
                    continue;
                }
                for (ItemRule ir : rules) {
                    if (!ir.isMandatory()) continue;
                    missingItemRules.add(ir);
                }
            }
        }
        catch (ConsoleTerminatedException e) {
            log.info("User interrupt occurred");
            this.terminate("User interrupt occurred");
        }
        return missingItemRules.isEmpty() ? null : new ItemRuleList(missingItemRules);
    }

    private void writeToken(Token[] tokens) {
        for (Token token : tokens) {
            this.writeToken(token);
        }
    }

    private void writeToken(Token token) {
        if (token.getType() == TokenType.TEXT) {
            this.console.write(token.stringify());
        } else {
            String str = token.stringify();
            this.console.setStyle("CYAN");
            this.console.write(str.substring(0, 2));
            this.console.styleOff();
            this.console.write(str.substring(2, str.length() - 1));
            this.console.setStyle("CYAN");
            this.console.write(str.substring(str.length() - 1));
            this.console.styleOff();
        }
    }

    private ItemRuleList checkRequiredParameters(ItemRuleList itemRuleList) {
        LinkedHashSet<ItemRule> missingItemRules = new LinkedHashSet<ItemRule>();
        ItemExpression evaluator = new ItemExpression((Activity)this);
        for (ItemRule itemRule : itemRuleList) {
            String[] values = evaluator.evaluateAsStringArray(itemRule);
            if (values != null && values.length > 0) {
                this.getRequestAdapter().setParameter(itemRule.getName(), values);
                continue;
            }
            missingItemRules.add(itemRule);
        }
        return missingItemRules.isEmpty() ? null : new ItemRuleList(missingItemRules);
    }

    private ItemRuleList checkRequiredAttributes(ItemRuleList itemRuleList) {
        LinkedHashSet<ItemRule> missingItemRules = new LinkedHashSet<ItemRule>();
        ItemExpression evaluator = new ItemExpression((Activity)this);
        for (ItemRule itemRule : itemRuleList) {
            Object value = evaluator.evaluate(itemRule);
            if (value != null) {
                this.getRequestAdapter().setAttribute(itemRule.getName(), value);
                continue;
            }
            missingItemRules.add(itemRule);
        }
        return missingItemRules.isEmpty() ? null : new ItemRuleList(missingItemRules);
    }

    public <T extends Activity> T newActivity() {
        ShellActivity activity = new ShellActivity(this.service, this.console);
        activity.setOutputWriter(this.outputWriter);
        activity.setIncluded(true);
        return (T)((Object)activity);
    }
}

