/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandInterpreter;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.HelpFormatter;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.Options;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCommand
implements Command {
    private final CommandRegistry registry;
    private final Options options = new Options();
    private final List<Arguments> argumentsList = new ArrayList<Arguments>();

    public AbstractCommand(CommandRegistry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Command registry must not be null");
        }
        this.registry = registry;
    }

    public CommandRegistry getCommandRegistry() {
        return this.registry;
    }

    public CommandInterpreter getInterpreter() {
        return this.registry.getInterpreter();
    }

    public ShellService getService() {
        ShellService service;
        ShellService shellService = service = this.getInterpreter() != null ? this.getInterpreter().getService() : null;
        if (service == null || !service.getServiceController().isActive()) {
            throw new IllegalStateException("SERVICE NOT AVAILABLE");
        }
        return service;
    }

    public boolean isServiceAvailable() {
        return this.getInterpreter() != null && this.getInterpreter().getService() != null;
    }

    protected void addOption(Option option) {
        this.options.addOption(option);
    }

    protected void addArguments(Arguments arguments) {
        this.argumentsList.add(arguments);
    }

    protected Arguments touchArguments() {
        Arguments arguments = new Arguments();
        this.addArguments(arguments);
        return arguments;
    }

    protected void skipParsingAtNonOption() {
        this.options.setSkipParsingAtNonOption(true);
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public List<Arguments> getArgumentsList() {
        return this.argumentsList;
    }

    @Override
    public void printHelp(Console console) {
        if (this.getDescriptor().getDescription() != null) {
            console.writeLine(this.getDescriptor().getDescription());
        }
        this.printQuickHelp(console);
    }

    @Override
    public void printQuickHelp(Console console) {
        HelpFormatter formatter = new HelpFormatter(console);
        formatter.printHelp(this);
    }
}

