/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.shell.console.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OutputRedirection {
    private final Operator operator;
    private String operand;

    public OutputRedirection(Operator operator) {
        this.operator = operator;
    }

    public String getOperand() {
        return this.operand;
    }

    public void setOperand(String operand) {
        this.operand = operand;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OutputRedirection) {
            OutputRedirection redirection = (OutputRedirection)o;
            return redirection.getOperand().equals(this.operand) && redirection.getOperator().equals((Object)this.operator);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + this.operator.hashCode();
        result = 31 * result + (this.operand != null ? this.operand.hashCode() : 0);
        return result;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("operator", (Object)this.operator);
        tsb.append("operand", (Object)this.operand);
        return tsb.toString();
    }

    public static String serialize(Collection<OutputRedirection> redirectionList) {
        StringBuilder sb = new StringBuilder();
        if (redirectionList != null) {
            for (OutputRedirection redirection : redirectionList) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append((Object)redirection.getOperator()).append(" ");
                sb.append(redirection.getOperand());
            }
        }
        return sb.toString();
    }

    public static PrintWriter determineOutputWriter(List<OutputRedirection> redirectionList, Console console) throws FileNotFoundException, UnsupportedEncodingException {
        Writer[] redirectionWriters = OutputRedirection.getRedirectionWriters(redirectionList, console);
        PrintWriter outputWriter = null;
        if (redirectionWriters != null) {
            if (redirectionWriters.length == 1) {
                outputWriter = new PrintWriter(redirectionWriters[0]);
            } else if (redirectionWriters.length > 1) {
                outputWriter = new PrintWriter(new MultiWriter(redirectionWriters));
            }
        }
        return outputWriter;
    }

    private static Writer[] getRedirectionWriters(List<OutputRedirection> redirectionList, Console console) throws FileNotFoundException, UnsupportedEncodingException {
        if (redirectionList != null && !redirectionList.isEmpty()) {
            ArrayList<OutputStreamWriter> writers = new ArrayList<OutputStreamWriter>(redirectionList.size());
            for (OutputRedirection redirection : redirectionList) {
                if (!StringUtils.hasText((String)redirection.getOperand())) {
                    throw new FileNotFoundException("Target file for redirection not specified");
                }
                Path path = Paths.get(redirection.getOperand(), new String[0]);
                File file = path.isAbsolute() ? path.toFile() : (console.getWorkingDir() != null ? new File(console.getWorkingDir(), redirection.getOperand()) : new File(redirection.getOperand()));
                file.getParentFile().mkdirs();
                boolean append = redirection.getOperator() == Operator.APPEND_OUT;
                FileOutputStream stream = new FileOutputStream(file, append);
                writers.add(new OutputStreamWriter((OutputStream)stream, console.getEncoding()));
            }
            return writers.toArray(new Writer[0]);
        }
        return null;
    }

    public static class MultiWriter
    extends Writer {
        private final Writer[] writers;

        public MultiWriter(Writer[] writers) {
            this.writers = writers;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (Writer writer : this.writers) {
                writer.write(cbuf, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            for (Writer writer : this.writers) {
                try {
                    writer.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void close() throws IOException {
            int unclosed = 0;
            for (Writer writer : this.writers) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    ++unclosed;
                }
            }
            if (unclosed > 0) {
                throw new IOException("Failed to close the multi-writer");
            }
        }
    }

    public static enum Operator {
        OVERWRITE_OUT(">"),
        APPEND_OUT(">>");

        private final String alias;

        private Operator(String alias) {
            this.alias = alias;
        }

        public String toString() {
            return this.alias;
        }
    }
}

