/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ShellConfig;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandInterpreter;
import com.aspectran.shell.command.CommandLineParser;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.ConsoleTerminatedException;
import com.aspectran.shell.command.OutputRedirection;
import com.aspectran.shell.command.ShellCommandRegistry;
import com.aspectran.shell.command.TransletCommandLine;
import com.aspectran.shell.command.builtins.QuitCommand;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.console.ConsoleWrapper;
import com.aspectran.shell.service.AspectranShellService;
import com.aspectran.shell.service.ShellService;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ShellCommandInterpreter
implements CommandInterpreter {
    private static final Log log = LogFactory.getLog(ShellCommandInterpreter.class);
    private final Console console;
    private ShellCommandRegistry commandRegistry;
    private AspectranShellService service;

    public ShellCommandInterpreter(Console console) {
        if (console == null) {
            throw new IllegalArgumentException("console must not be null");
        }
        this.console = console;
    }

    @Override
    public Console getConsole() {
        return this.console;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public ShellService getService() {
        return this.service;
    }

    public void init(String basePath, File aspectranConfigFile) throws Exception {
        ShellConfig shellConfig;
        String commandPrompt;
        AspectranConfig aspectranConfig = new AspectranConfig();
        try {
            AponReader.parse((File)aspectranConfigFile, (Parameters)aspectranConfig);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse aspectran config file: " + aspectranConfigFile, e);
        }
        if (basePath != null) {
            aspectranConfig.touchContextConfig().setBasePath(basePath);
        }
        if ((commandPrompt = (shellConfig = aspectranConfig.touchShellConfig()).getPrompt()) != null) {
            this.console.setCommandPrompt(commandPrompt);
        }
        if (aspectranConfig.hasContextConfig()) {
            this.service = AspectranShellService.create(aspectranConfig, this.console);
            this.service.start();
        } else {
            String greetings = shellConfig.getGreetings();
            if (StringUtils.hasText((String)greetings)) {
                this.console.writeLine(greetings);
            }
        }
        this.commandRegistry = new ShellCommandRegistry(this);
        this.commandRegistry.addCommand(shellConfig.getCommands());
        if (this.commandRegistry.getCommand(QuitCommand.class) == null) {
            this.commandRegistry.addCommand(QuitCommand.class);
        }
        File workingDir = this.determineWorkingDir(basePath, shellConfig.getWorkingDir());
        this.console.setWorkingDir(workingDir);
        String historyFile = shellConfig.getHistoryFile();
        if (!StringUtils.isEmpty((String)historyFile)) {
            historyFile = new File(basePath, historyFile).getCanonicalPath();
            this.console.setCommandHistoryFile(historyFile);
        }
        this.console.setInterpreter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        try {
            while (true) {
                CommandLineParser lineParser;
                String commandLine;
                if (!StringUtils.hasLength((String)(commandLine = this.console.readCommandLine())) || (lineParser = new CommandLineParser(commandLine)).getCommandName() == null) {
                    continue;
                }
                Command command = null;
                if (this.commandRegistry != null) {
                    command = this.commandRegistry.getCommand(lineParser.getCommandName());
                }
                if (command != null) {
                    this.execute(command, lineParser);
                    continue;
                }
                if (this.service != null) {
                    TransletCommandLine transletCommandLine = new TransletCommandLine(lineParser);
                    this.execute(transletCommandLine);
                    continue;
                }
                this.console.writeLine("No command mapped to '" + lineParser.getCommandName() + "'");
            }
        }
        catch (ConsoleTerminatedException commandLine) {
            if (this.service != null && this.service.getServiceController().isActive() && log.isDebugEnabled()) {
                log.debug("Do not terminate this application while releasing all resources");
            }
        }
        catch (Throwable e) {
            try {
                log.error("Error occurred while processing shell command", e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (this.service != null && this.service.getServiceController().isActive() && log.isDebugEnabled()) {
                    log.debug("Do not terminate this application while releasing all resources");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Command command, CommandLineParser lineParser) {
        ConsoleWrapper wrappedConsole = new ConsoleWrapper(this.console);
        try (PrintWriter outputWriter = null;){
            ParsedOptions options = lineParser.parseOptions(command.getOptions());
            outputWriter = OutputRedirection.determineOutputWriter(lineParser.getRedirectionList(), wrappedConsole);
            wrappedConsole.setWriter(outputWriter);
            command.execute(options, wrappedConsole);
        }
    }

    private void execute(TransletCommandLine transletCommandLine) {
        if (transletCommandLine.getRequestName() != null) {
            try {
                this.service.translate(transletCommandLine, this.console);
            }
            catch (TransletNotFoundException e) {
                this.console.writeError("No command or translet mapped to '" + e.getTransletName() + "'");
            }
            catch (ConsoleTerminatedException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("Failed to execute command: " + transletCommandLine.getLineParser().getCommandLine(), (Throwable)e);
            }
        } else {
            this.console.writeError("No command or translet mapped to '" + transletCommandLine.getLineParser().getCommandLine() + "'");
        }
    }

    public void release() {
        if (this.service != null) {
            this.service.stop();
            this.service = null;
        }
    }

    private File determineWorkingDir(String baseDir, String workingDir) {
        File dir = null;
        if (baseDir != null && workingDir != null) {
            Path basePath = Paths.get(baseDir, new String[0]);
            Path workingPath = Paths.get(workingDir, new String[0]);
            dir = workingPath.startsWith(basePath) && workingPath.isAbsolute() ? workingPath.toFile() : new File(baseDir, workingDir);
        } else if (workingDir != null) {
            dir = new File(workingDir);
        } else {
            String userDir = System.getProperty("user.dir");
            if (userDir != null) {
                dir = new File(userDir);
            }
        }
        if (dir != null) {
            dir.mkdirs();
        }
        return dir;
    }
}

