/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command;

import com.aspectran.core.context.resource.AspectranClassLoader;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandInterpreter;
import com.aspectran.shell.command.CommandRegistry;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ShellCommandRegistry
implements CommandRegistry {
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();
    private final CommandInterpreter interpreter;

    public ShellCommandRegistry(CommandInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public CommandInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public Command getCommand(String commandName) {
        return this.commands.get(commandName);
    }

    @Override
    public Command getCommand(Class<? extends Command> commandClass) {
        for (Command command : this.commands.values()) {
            if (!command.getClass().equals(commandClass)) continue;
            return command;
        }
        return null;
    }

    @Override
    public Collection<Command> getAllCommands() {
        return this.commands.values();
    }

    public void addCommand(String ... classNames) {
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    ClassLoader classLoader = AspectranClassLoader.getDefaultClassLoader();
                    Class<?> commandClass = classLoader.loadClass(className);
                    this.addCommand(commandClass);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unable to load Command class: " + className, e);
                }
            }
        }
    }

    public void addCommand(Class<? extends Command> commandClass) {
        Object[] args = new Object[]{this};
        Class[] argTypes = new Class[]{CommandRegistry.class};
        Command command = (Command)ClassUtils.createInstance(commandClass, (Object[])args, (Class[])argTypes);
        this.commands.put(command.getDescriptor().getName(), command);
    }
}

