/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.converter.RuleToParamsConverter;
import com.aspectran.core.context.rule.params.AspectParameters;
import com.aspectran.core.util.apon.AponWriter;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public class AspectCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "aspect";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public AspectCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("l").longName("list").hasValues().optionalValue().valueName("keywords").desc("Print list of all aspects or those filtered by given keywords").build());
        this.addOption(Option.builder("d").longName("detail").hasValues().optionalValue().valueName("aspect_id").desc("Print detailed information for the aspect").build());
        this.addOption(Option.builder("enable").hasValues().valueName("aspect_id").desc("Enable an aspect with a given name").build());
        this.addOption(Option.builder("disable").hasValues().valueName("aspect_id").desc("Disable an aspect with a given name").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
    }

    @Override
    public void execute(ParsedOptions options, Console console) throws Exception {
        ShellService service = this.getService();
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (options.hasOption("list")) {
            String[] keywords = options.getValues("list");
            this.listAspects(service, console, keywords);
        } else if (options.hasOption("detail")) {
            String[] aspectIds = options.getValues("detail");
            this.detailAspectRule(service, console, aspectIds);
        } else if (options.hasOption("enable")) {
            String[] aspectIds = options.getValues("enable");
            this.changeAspectActiveState(service, console, aspectIds, false);
        } else if (options.hasOption("disable")) {
            String[] aspectIds = options.getValues("disable");
            this.changeAspectActiveState(service, console, aspectIds, true);
        } else {
            this.printQuickHelp(console);
        }
    }

    private void listAspects(ShellService service, Console console, String[] keywords) {
        AspectRuleRegistry aspectRuleRegistry = service.getActivityContext().getAspectRuleRegistry();
        Collection aspectRules = aspectRuleRegistry.getAspectRules();
        console.writeLine("-%4s-+-%-45s-+-%-8s-+-%-8s-", "----", "---------------------------------------------", "--------", "--------");
        console.writeLine(" %4s | %-45s | %-8s | %-8s ", "No.", "Aspect ID", "Isolated", "Enabled");
        console.writeLine("-%4s-+-%-45s-+-%-8s-+-%-8s-", "----", "---------------------------------------------", "--------", "--------");
        int num = 0;
        for (AspectRule aspectRule : aspectRules) {
            if (keywords != null) {
                boolean exists = false;
                for (String keyw : keywords) {
                    if (!aspectRule.getId().toLowerCase().contains(keyw.toLowerCase())) continue;
                    exists = true;
                }
                if (!exists) continue;
            }
            console.write("%5d | %-45s ", ++num, aspectRule.getId());
            console.write("|");
            if (aspectRule.isIsolated()) {
                console.setStyle("YELLOW");
            }
            console.write(" %-8s ", aspectRule.isIsolated());
            console.styleOff();
            console.write("|");
            if (!aspectRule.isIsolated()) {
                if (aspectRule.isDisabled()) {
                    console.setStyle("RED");
                } else {
                    console.setStyle("BLUE");
                }
            }
            console.writeLine(" %-8s ", !aspectRule.isDisabled());
            console.styleOff();
        }
        if (num == 0) {
            console.writeLine("%33s %s", " ", "No Data");
        }
        console.writeLine("-%4s-+-%-45s-+-%-8s-+-%-8s-", "----", "---------------------------------------------", "--------", "--------");
    }

    private void detailAspectRule(ShellService service, Console console, String[] aspectIds) throws IOException {
        ArrayList<AspectRule> aspectRules;
        AspectRuleRegistry aspectRuleRegistry = service.getActivityContext().getAspectRuleRegistry();
        if (aspectIds == null || aspectIds.length == 0) {
            aspectRules = aspectRuleRegistry.getAspectRules();
        } else {
            aspectRules = new ArrayList<AspectRule>();
            for (String aspectId : aspectIds) {
                AspectRule aspectRule = aspectRuleRegistry.getAspectRule(aspectId);
                if (aspectRule == null) {
                    try {
                        int num = Integer.parseInt(aspectId) - 1;
                        aspectRule = aspectRuleRegistry.getAspectRules().toArray(new AspectRule[0])[num];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (aspectRule == null) {
                    console.writeError("Unknown aspect: " + aspectId);
                    return;
                }
                aspectRules.add(aspectRule);
            }
        }
        int count = 0;
        for (AspectRule aspectRule : aspectRules) {
            AspectParameters aspectParameters = RuleToParamsConverter.toAspectParameters((AspectRule)aspectRule);
            if (count == 0) {
                console.writeLine("----------------------------------------------------------------------------");
            }
            AponWriter aponWriter = new AponWriter((Writer)console.getWriter());
            aponWriter.write((Parameters)aspectParameters);
            console.writeLine("----------------------------------------------------------------------------");
            ++count;
        }
    }

    private void changeAspectActiveState(ShellService service, Console console, String[] aspectIds, boolean disabled) {
        AspectRuleRegistry aspectRuleRegistry = service.getActivityContext().getAspectRuleRegistry();
        ArrayList<AspectRule> aspectRules = new ArrayList<AspectRule>();
        for (String aspectId : aspectIds) {
            AspectRule aspectRule = aspectRuleRegistry.getAspectRule(aspectId);
            if (aspectRule == null) {
                console.writeError("Unknown aspect: " + aspectId);
                return;
            }
            if (aspectRule.isIsolated()) {
                console.writeError("Can not be disabled or enabled for isolated Aspect '" + aspectId + "'.");
                return;
            }
            aspectRules.add(aspectRule);
        }
        for (AspectRule aspectRule : aspectRules) {
            if (disabled) {
                if (aspectRule.isDisabled()) {
                    console.writeLine("Aspect '" + aspectRule.getId() + "' is already inactive.");
                    continue;
                }
                aspectRule.setDisabled(Boolean.valueOf(true));
                console.writeLine("Aspect '" + aspectRule.getId() + "' is now inactive.");
                continue;
            }
            if (!aspectRule.isDisabled()) {
                console.writeLine("Aspect '" + aspectRule.getId() + "' is already active.");
                continue;
            }
            aspectRule.setDisabled(Boolean.valueOf(false));
            console.writeLine("Aspect '" + aspectRule.getId() + "' is now active.");
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return AspectCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return AspectCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Show registered aspects, or disable or enable them";
        }

        @Override
        public String getUsage() {
            return null;
        }
    }
}

