/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;

public class EchoCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "echo";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public EchoCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
        Arguments arguments = this.touchArguments();
        arguments.put("<message>", "Specifies the text to display on the screen");
        arguments.setRequired(false);
    }

    @Override
    public void execute(ParsedOptions options, Console console) throws Exception {
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else {
            String message = String.join((CharSequence)" ", options.getArgs());
            console.writeLine(message);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return EchoCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return EchoCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Displays a message on the screen";
        }

        @Override
        public String getUsage() {
            return null;
        }
    }
}

