/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.HelpFormatter;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionUtils;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class HelpCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "help";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public HelpCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("h").longName(COMMAND_NAME).desc("Display help for this command").build());
        Arguments arguments = this.touchArguments();
        arguments.put("<commands>", "Commands to display help");
        arguments.setRequired(false);
    }

    @Override
    public void execute(ParsedOptions options, Console console) throws Exception {
        if (options.hasOption(COMMAND_NAME)) {
            this.printHelp(console);
            return;
        }
        String[] targetCommands = null;
        if (options.hasArgs()) {
            targetCommands = options.getArgs();
        }
        if (targetCommands == null) {
            this.printHelp(null, console);
            if (this.isServiceAvailable()) {
                this.getService().printHelp();
            }
        } else if (targetCommands.length == 1) {
            Command command = this.getCommandRegistry().getCommand(targetCommands[0]);
            if (command != null) {
                command.printHelp(console);
            } else {
                console.writeLine("No command mapped to '" + targetCommands[0] + "'");
            }
        } else {
            console.setStyle("bold");
            console.writeLine("Built-in commands:");
            console.styleOff();
            this.printHelp(targetCommands, console);
        }
    }

    @Override
    public List<Arguments> getArgumentsList() {
        List<Arguments> argumentsList = super.getArgumentsList();
        argumentsList.clear();
        LinkedList<Command> list = new LinkedList<Command>(this.getCommandRegistry().getAllCommands());
        list.sort(Comparator.comparing(Command::getDescriptor, Comparator.comparing(Command.Descriptor::getName)));
        Arguments arguments = this.touchArguments();
        arguments.setTitle("Commands:");
        for (Command command : list) {
            String commandName = command.getDescriptor().getName();
            arguments.put(commandName, "Display help for command " + commandName);
        }
        return argumentsList;
    }

    private void printHelp(String[] targetCommands, Console console) {
        if (targetCommands == null) {
            console.setStyle("bold");
            console.writeLine("Available commands:");
            console.styleOff();
        }
        int lineWidth = 76;
        int commandWidth = this.maxLengthOfCommandName(targetCommands);
        String lpad = OptionUtils.createPadding(3);
        String dpad = OptionUtils.createPadding(3);
        for (Command command : this.getCommandRegistry().getAllCommands()) {
            String line;
            String name = command.getDescriptor().getName();
            if (commandWidth != 0 && targetCommands != null && !this.contains(name, targetCommands) || (line = this.renderCommand(command, 76, commandWidth, lpad, dpad)) == null) continue;
            console.writeLine(line);
        }
    }

    private int maxLengthOfCommandName(String[] filteredCommands) {
        int max = 0;
        for (Command command : this.getCommandRegistry().getAllCommands()) {
            String commandName = command.getDescriptor().getName();
            if (filteredCommands != null && !this.contains(commandName, filteredCommands) || commandName.length() <= max) continue;
            max = commandName.length();
        }
        return max;
    }

    private boolean contains(String commandName, String[] filteredCommands) {
        for (String target : filteredCommands) {
            if (!commandName.equals(target)) continue;
            return true;
        }
        return false;
    }

    private String renderCommand(Command command, int lineWidth, int commandWidth, String leftPad, String descPad) {
        String name = command.getDescriptor().getName();
        String desc = command.getDescriptor().getDescription();
        StringBuilder sb = new StringBuilder();
        sb.append(leftPad).append(name);
        if (name.length() < commandWidth) {
            sb.append(OptionUtils.createPadding(commandWidth - name.length()));
        }
        sb.append(descPad);
        HelpFormatter.renderWrappedText(sb, lineWidth, sb.length(), desc);
        return sb.length() > 0 ? sb.toString() : null;
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return HelpCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return HelpCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Display helpful information about builtin commands";
        }

        @Override
        public String getUsage() {
            return "help [-h] [<commands>]";
        }
    }
}

