/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.jetty.JettyServer;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;
import java.net.BindException;

public class JettyCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "jetty";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public JettyCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("server").valueName("name").withEqualSign().desc("ID of bean that defined Jetty server").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
        Arguments arguments = this.touchArguments();
        arguments.setTitle("Commands:");
        arguments.put("start", "Start Jetty server");
        arguments.put("stop", "Stop Jetty server");
        arguments.put("restart", "Restart Jetty server");
        arguments.put("status", "Display a brief status report");
        arguments.setRequired(true);
    }

    @Override
    public void execute(ParsedOptions options, Console console) throws Exception {
        JettyServer jettyServer;
        if (!options.hasOptions() && !options.hasArgs()) {
            this.printQuickHelp(console);
            return;
        }
        if (options.hasOption("help")) {
            this.printHelp(console);
            return;
        }
        ShellService service = this.getService();
        String serverName = options.getValue("server", "jetty.server");
        BeanRegistry beanRegistry = service.getActivityContext().getBeanRegistry();
        try {
            jettyServer = (JettyServer)beanRegistry.getBean(JettyServer.class, serverName);
        }
        catch (Exception e) {
            console.writeError("Jetty server is not available. Cause: " + e.getMessage());
            return;
        }
        if (options.hasArgs()) {
            String command = options.getFirstArg();
            if ("start".equals(command)) {
                if (jettyServer.isRunning()) {
                    console.writeError("Jetty server is already running");
                    return;
                }
                try {
                    jettyServer.start();
                    this.printStatus(jettyServer, console);
                }
                catch (BindException e) {
                    console.writeError("Jetty Server Error - Port already in use");
                }
            } else if ("stop".equals(command)) {
                if (!jettyServer.isRunning()) {
                    console.writeError("Jetty server is not running");
                    return;
                }
                try {
                    jettyServer.stop();
                    this.printStatus(jettyServer, console);
                }
                catch (BindException e) {
                    console.writeError("Jetty Server Error - " + e.getMessage());
                }
            } else if ("restart".equals(command)) {
                try {
                    if (jettyServer.isRunning()) {
                        jettyServer.stop();
                    }
                    jettyServer.start();
                    this.printStatus(jettyServer, console);
                }
                catch (BindException e) {
                    console.writeError("Jetty Server Error - Port already in use");
                }
            } else if ("status".equals(command)) {
                this.printStatus(jettyServer, console);
            } else {
                console.writeError("Unknown command '" + String.join((CharSequence)" ", options.getArgs()) + "'");
                this.printQuickHelp(console);
            }
        } else {
            this.printQuickHelp(console);
        }
    }

    private void printStatus(JettyServer jettyServer, Console console) {
        console.writeLine("----------------------------------------------------------------------------");
        console.setStyle("YELLOW");
        console.write(jettyServer.getState());
        console.styleOff();
        console.writeLine(" - Jetty " + JettyServer.getVersion());
        console.writeLine("----------------------------------------------------------------------------");
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return JettyCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return JettyCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Use the command 'jetty' to control the Jetty server";
        }

        @Override
        public String getUsage() {
            return null;
        }
    }
}

