/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.converter.RuleToParamsConverter;
import com.aspectran.core.context.rule.params.ScheduleParameters;
import com.aspectran.core.context.rule.params.SchedulerParameters;
import com.aspectran.core.context.rule.params.TriggerParameters;
import com.aspectran.core.util.apon.AponWriter;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Set;

public class JobCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "job";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public JobCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("l").longName("list").hasValues().optionalValue().valueName("keywords").desc("Print list of all scheduled jobs or those filtered by given keywords").build());
        this.addOption(Option.builder("d").longName("detail").hasValues().optionalValue().valueName("translet_name").desc("Print detailed information for the scheduled job").build());
        this.addOption(Option.builder("enable").hasValues().valueName("translet_name").desc("Enable a scheduled job with a given name").build());
        this.addOption(Option.builder("disable").hasValues().valueName("translet_name").desc("Disable a scheduled job with a given name").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
    }

    @Override
    public void execute(ParsedOptions options, Console console) throws Exception {
        ShellService service = this.getService();
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (options.hasOption("list")) {
            String[] keywords = options.getValues("list");
            this.listScheduledJobs(service, console, keywords);
        } else if (options.hasOption("detail")) {
            String[] transletNames = options.getValues("detail");
            this.detailScheduledJobRule(service, console, transletNames);
        } else if (options.hasOption("enable")) {
            String[] transletNames = options.getValues("enable");
            this.changeJobActiveState(service, console, transletNames, false);
        } else if (options.hasOption("disable")) {
            String[] transletNames = options.getValues("disable");
            this.changeJobActiveState(service, console, transletNames, true);
        } else {
            this.printQuickHelp(console);
        }
    }

    private void listScheduledJobs(ShellService service, Console console, String[] keywords) {
        ScheduleRuleRegistry scheduleRuleRegistry = service.getActivityContext().getScheduleRuleRegistry();
        console.writeLine("-%4s-+-%-20s-+-%-33s-+-%-8s-", "----", "--------------------", "---------------------------------", "--------");
        console.writeLine(" %4s | %-20s | %-33s | %-8s ", "No.", "Schedule ID", "Job Name", "Enabled");
        console.writeLine("-%4s-+-%-20s-+-%-33s-+-%-8s-", "----", "--------------------", "---------------------------------", "--------");
        int num = 0;
        for (ScheduleRule scheduleRule : scheduleRuleRegistry.getScheduleRules()) {
            for (ScheduledJobRule jobRule : scheduleRule.getScheduledJobRuleList()) {
                if (keywords != null) {
                    boolean exists = false;
                    for (String keyw : keywords) {
                        if (!jobRule.getTransletName().toLowerCase().contains(keyw.toLowerCase())) continue;
                        exists = true;
                    }
                    if (!exists) continue;
                }
                console.write("%5d | %-20s | %-33s |", ++num, scheduleRule.getId(), jobRule.getTransletName());
                if (jobRule.isDisabled()) {
                    console.setStyle("RED");
                } else {
                    console.setStyle("BLUE");
                }
                console.writeLine(" %-8s ", !jobRule.isDisabled());
                console.styleOff();
            }
        }
        if (num == 0) {
            console.writeLine("%33s %s", " ", "No Data");
        }
        console.writeLine("-%4s-+-%-20s-+-%-33s-+-%-8s-", "----", "--------------------", "---------------------------------", "--------");
    }

    private void detailScheduledJobRule(ShellService service, Console console, String[] transletNames) throws IOException {
        ScheduleRuleRegistry scheduleRuleRegistry = service.getActivityContext().getScheduleRuleRegistry();
        if (transletNames != null && transletNames.length > 0) {
            Set scheduledJobRules = scheduleRuleRegistry.getScheduledJobRules(transletNames);
            if (scheduledJobRules.isEmpty()) {
                console.writeError("Unknown scheduled job " + Arrays.toString(transletNames));
                return;
            }
            int count = 0;
            for (ScheduledJobRule jobRule : scheduledJobRules) {
                ScheduleRule scheduleRule = jobRule.getScheduleRule();
                ScheduleParameters scheduleParameters = new ScheduleParameters();
                scheduleParameters.putValueNonNull(ScheduleParameters.description, (Object)scheduleRule.getDescription());
                scheduleParameters.putValueNonNull(ScheduleParameters.id, (Object)scheduleRule.getId());
                SchedulerParameters schedulerParameters = (SchedulerParameters)scheduleParameters.newParameters(ScheduleParameters.scheduler);
                schedulerParameters.putValueNonNull(SchedulerParameters.bean, (Object)scheduleRule.getSchedulerBeanId());
                TriggerParameters triggerParameters = scheduleRule.getTriggerParameters();
                if (triggerParameters != null && scheduleRule.getTriggerType() != null) {
                    triggerParameters.putValueNonNull(TriggerParameters.type, (Object)scheduleRule.getTriggerType().toString());
                    schedulerParameters.putValue(SchedulerParameters.trigger, (Object)scheduleRule.getTriggerParameters());
                }
                scheduleParameters.putValue(ScheduleParameters.job, (Object)RuleToParamsConverter.toScheduledJobParameters((ScheduledJobRule)jobRule));
                if (count == 0) {
                    console.writeLine("----------------------------------------------------------------------------");
                }
                AponWriter aponWriter = new AponWriter((Writer)console.getWriter());
                aponWriter.write((Parameters)scheduleParameters);
                console.writeLine("----------------------------------------------------------------------------");
                ++count;
            }
            if (count == 0) {
                console.writeError("Unknown scheduled job " + Arrays.toString(transletNames));
            }
        } else {
            int count = 0;
            for (ScheduleRule scheduleRule : scheduleRuleRegistry.getScheduleRules()) {
                ScheduleParameters scheduleParameters = RuleToParamsConverter.toScheduleParameters((ScheduleRule)scheduleRule);
                if (count == 0) {
                    console.writeLine("----------------------------------------------------------------------------");
                }
                AponWriter aponWriter = new AponWriter((Writer)console.getWriter());
                aponWriter.write((Parameters)scheduleParameters);
                console.writeLine("----------------------------------------------------------------------------");
                ++count;
            }
        }
    }

    private void changeJobActiveState(ShellService service, Console console, String[] transletNames, boolean disabled) {
        ScheduleRuleRegistry scheduleRuleRegistry = service.getActivityContext().getScheduleRuleRegistry();
        Set scheduledJobRules = scheduleRuleRegistry.getScheduledJobRules(transletNames);
        if (scheduledJobRules.isEmpty()) {
            console.writeError("Unknown scheduled job " + Arrays.toString(transletNames));
            return;
        }
        for (ScheduledJobRule jobRule : scheduledJobRules) {
            if (disabled) {
                if (jobRule.isDisabled()) {
                    console.writeLine("Scheduled job '%s' on schedule '%s' is already inactive.", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
                    continue;
                }
                jobRule.setDisabled(Boolean.valueOf(true));
                console.writeLine("Scheduled job '%s' on schedule '%s' is now inactive.", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
                continue;
            }
            if (!jobRule.isDisabled()) {
                console.writeLine("Scheduled job '%s' on schedule '%s' is already active.", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
                continue;
            }
            jobRule.setDisabled(Boolean.valueOf(false));
            console.writeLine("Scheduled job '%s' on schedule '%s' is now active.", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return JobCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return JobCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Show scheduled jobs, or disable or enable them";
        }

        @Override
        public String getUsage() {
            return null;
        }
    }
}

