/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.core.util.StringUtils;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;

public class SysInfoCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "sysinfo";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public SysInfoCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("props").longName("system-properties").desc("Displays the JVM's system properties").build());
        this.addOption(Option.builder("cp").longName("class-path").desc("Displays JVM classpath information").build());
        this.addOption(Option.builder("mem").longName("memory-usage").desc("Displays memory information about current JVM").build());
        this.addOption(Option.builder("gc").longName("garbage-collection").desc("Performs garbage collection").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
    }

    @Override
    public void execute(ParsedOptions options, Console console) throws Exception {
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (options.hasOption("props")) {
            this.printSysProperties(console);
        } else if (options.hasOption("cp")) {
            this.printClasspath(console);
        } else if (options.hasOption("mem")) {
            this.mem(false, console);
        } else if (options.hasOption("gc")) {
            this.mem(true, console);
        } else {
            this.printQuickHelp(console);
        }
    }

    private void printSysProperties(Console console) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            console.writeLine("%1$30s   %2$s", entry.getKey(), entry.getValue());
        }
    }

    private void printClasspath(Console console) {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        for (String line : StringUtils.split((String)bean.getClassPath(), (String)File.pathSeparator)) {
            console.writeLine(line);
        }
    }

    private void mem(boolean gc, Console console) {
        long total = Runtime.getRuntime().totalMemory();
        long before = Runtime.getRuntime().freeMemory();
        console.writeLine("%-24s %12s", "Total memory", StringUtils.convertToHumanFriendlyByteSize((long)total));
        console.writeLine("%-24s %12s", "Used memory", StringUtils.convertToHumanFriendlyByteSize((long)(total - before)));
        if (gc) {
            System.gc();
            System.gc();
            System.runFinalization();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long after = Runtime.getRuntime().freeMemory();
            console.writeLine("%-24s %12s", "Free memory before GC", StringUtils.convertToHumanFriendlyByteSize((long)before));
            console.writeLine("%-24s %12s", "Free memory after GC", StringUtils.convertToHumanFriendlyByteSize((long)after));
            console.writeLine("%-24s %12s", "Memory gained with GC", StringUtils.convertToHumanFriendlyByteSize((long)(after - before)));
        } else {
            console.writeLine("%-24s %12s", "Free memory", StringUtils.convertToHumanFriendlyByteSize((long)before));
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return SysInfoCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return SysInfoCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Displays current JVM runtime information";
        }

        @Override
        public String getUsage() {
            return null;
        }
    }
}

