/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.converter.RuleToParamsConverter;
import com.aspectran.core.context.rule.params.TransletParameters;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.apon.AponWriter;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandLineParser;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.TransletCommandLine;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public class TransletCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "translet";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public TransletCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("l").longName("list").hasValues().optionalValue().valueName("keywords").desc("Print list of all translets or those filtered by given keywords").build());
        this.addOption(Option.builder("la").longName("list-all").hasValues().optionalValue().valueName("keywords").desc("Print list of all translets or those filtered by given keywords (Include all translets that are not exposed)").build());
        this.addOption(Option.builder("d").longName("detail").hasValues().optionalValue().valueName("translet_name").desc("Print detailed information for the translet").build());
        this.addOption(Option.builder("da").longName("detail-all").hasValues().optionalValue().valueName("translet_name").desc("Print detailed information for the translet (Include all translets that are not exposed)").build());
        this.addOption(Option.builder("m").longName("method").hasValue().optionalValue().valueName("request_method").desc("Specifies the request method for the translet\n(GET, PUT, POST, DELETE)").build());
        this.addOption(Option.builder("v").longName("verbose").desc("Display description about the translet").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
        Arguments arguments = this.touchArguments();
        arguments.put("<translet_name>", "Name of the translet to execute");
        arguments.setRequired(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ParsedOptions options, Console console) throws Exception {
        ShellService service = this.getService();
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (options.hasOption("list")) {
            String[] keywords = options.getValues("list");
            this.listTranslets(service, console, keywords, false);
        } else if (options.hasOption("list-all")) {
            String[] keywords = options.getValues("list-all");
            this.listTranslets(service, console, keywords, true);
        } else if (options.hasOption("detail")) {
            String[] transletNames = options.getValues("detail");
            String method = options.getValue("method");
            MethodType requestMethod = MethodType.resolve((String)method);
            if (method != null && requestMethod == null) {
                console.writeError("No request method type for '" + method + "'");
                return;
            }
            this.detailTransletRule(service, console, transletNames, requestMethod, false);
        } else if (options.hasOption("detail-all")) {
            String[] transletNames = options.getValues("detail-all");
            String method = options.getValue("method");
            MethodType requestMethod = MethodType.resolve((String)method);
            if (method != null && requestMethod == null) {
                console.writeError("No request method type for '" + method + "'");
                return;
            }
            this.detailTransletRule(service, console, transletNames, requestMethod, true);
        } else if (options.hasArgs()) {
            CommandLineParser lineParser = new CommandLineParser(options.getFirstArg());
            TransletCommandLine transletCommandLine = new TransletCommandLine(lineParser);
            boolean verbose = service.isVerbose();
            try {
                if (options.hasOption("verbose")) {
                    service.setVerbose(true);
                }
                service.translate(transletCommandLine, console);
            }
            catch (TransletNotFoundException e) {
                console.writeError("No translet mapped to '" + e.getTransletName() + "'");
            }
            finally {
                service.setVerbose(verbose);
            }
        } else {
            this.printQuickHelp(console);
        }
    }

    private void listTranslets(ShellService service, Console console, String[] keywords, boolean all) {
        TransletRuleRegistry transletRuleRegistry = service.getActivityContext().getTransletRuleRegistry();
        Collection transletRules = transletRuleRegistry.getTransletRules();
        console.writeLine("-%4s-+-%-67s-", "----", "-------------------------------------------------------------------");
        console.writeLine(" %4s | %-67s ", "No.", "Translet Name");
        console.writeLine("-%4s-+-%-67s-", "----", "-------------------------------------------------------------------");
        int num = 0;
        for (TransletRule transletRule : transletRules) {
            Object[] requestMethods;
            String transletName = transletRule.getName();
            if (!all && !service.isExposable(transletName)) continue;
            if (keywords != null) {
                boolean exists = false;
                for (String keyw : keywords) {
                    if (!transletName.toLowerCase().contains(keyw.toLowerCase())) continue;
                    exists = true;
                }
                if (!exists) continue;
            }
            if ((requestMethods = transletRule.getAllowedMethods()) != null) {
                transletName = StringUtils.toDelimitedString((Object[])requestMethods, (String)",") + " " + transletName;
            }
            console.writeLine("%5d | %s", ++num, transletName);
        }
        if (num == 0) {
            console.writeLine("%33s %s", " ", "No Data");
        }
        console.writeLine("-%4s-+-%-67s-", "----", "-------------------------------------------------------------------");
    }

    private void detailTransletRule(ShellService service, Console console, String[] transletNames, MethodType requestMethod, boolean all) throws IOException {
        ArrayList<TransletRule> transletRules;
        TransletRuleRegistry transletRuleRegistry = service.getActivityContext().getTransletRuleRegistry();
        if (transletNames == null || transletNames.length == 0) {
            transletRules = transletRuleRegistry.getTransletRules();
        } else {
            transletRules = new ArrayList<TransletRule>();
            for (String transletName : transletNames) {
                TransletRule transletRule;
                if (requestMethod != null) {
                    transletRule = transletRuleRegistry.getTransletRule(transletName, requestMethod);
                } else {
                    MethodType requestMethod2 = null;
                    for (MethodType methodType : MethodType.values()) {
                        if (!transletName.startsWith(methodType.name() + " ")) continue;
                        requestMethod2 = methodType;
                        transletName = transletName.substring(methodType.name().length()).trim();
                    }
                    transletRule = requestMethod2 != null ? transletRuleRegistry.getTransletRule(transletName, requestMethod2) : transletRuleRegistry.getTransletRule(transletName);
                }
                if (transletRule == null) {
                    try {
                        int num = Integer.parseInt(transletName) - 1;
                        transletRule = transletRuleRegistry.getTransletRules().toArray(new TransletRule[0])[num];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (transletRule == null) {
                    if (requestMethod != null) {
                        console.writeError("Unknown translet: " + requestMethod + " " + transletName);
                    } else {
                        console.writeError("Unknown translet: " + transletName);
                    }
                    return;
                }
                transletRules.add(transletRule);
            }
        }
        int count = 0;
        for (TransletRule transletRule : transletRules) {
            if (!all && !service.isExposable(transletRule.getName())) continue;
            TransletParameters transletParameters = RuleToParamsConverter.toTransletParameters((TransletRule)transletRule);
            if (count == 0) {
                console.writeLine("----------------------------------------------------------------------------");
            }
            AponWriter aponWriter = new AponWriter((Writer)console.getWriter());
            aponWriter.write((Parameters)transletParameters);
            console.writeLine("----------------------------------------------------------------------------");
            ++count;
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return TransletCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return TransletCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Translet run, or you can find them";
        }

        @Override
        public String getUsage() {
            return null;
        }
    }
}

