/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.builtins;

import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.Console;

public class VerboseCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "verbose";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public VerboseCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
        Arguments arguments = this.touchArguments();
        arguments.setTitle("Commands:");
        arguments.put("on", "Enable verbose mode");
        arguments.put("off", "Disable verbose mode");
    }

    @Override
    public void execute(ParsedOptions options, Console console) throws Exception {
        if (options.hasOption("help")) {
            this.printHelp(console);
        } else if (options.hasArgs()) {
            String arg = options.getFirstArg();
            if ("on".equals(arg)) {
                this.getService().setVerbose(true);
                console.writeLine("Verbose mode is enabled.");
                console.writeLine("Displays a description of the translet before it is executed.");
            } else if ("off".equals(arg)) {
                this.getService().setVerbose(false);
                console.writeLine("Verbose mode is disabled.");
                console.writeLine("Do not displays a description of the translet before it is executed.");
            } else {
                console.writeError("Unknown command '" + String.join((CharSequence)" ", options.getArgs()) + "'");
                this.printQuickHelp(console);
            }
        } else {
            this.printQuickHelp(console);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return VerboseCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return VerboseCommand.COMMAND_NAME;
        }

        @Override
        public String getDescription() {
            return "Turns on or off the translet description display feature";
        }

        @Override
        public String getUsage() {
            return null;
        }
    }
}

