/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.core.util.StringUtils;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionGroup;
import com.aspectran.shell.command.option.OptionUtils;
import com.aspectran.shell.command.option.Options;
import com.aspectran.shell.console.Console;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HelpFormatter {
    private static final String NEW_LINE = System.lineSeparator();
    public static final int DEFAULT_WIDTH = 76;
    public static final int DEFAULT_MAX_LEFT_WIDTH = 15;
    public static final int DEFAULT_LEFT_PAD = 3;
    public static final int DEFAULT_DESC_PAD = 3;
    private static final String DEFAULT_SYNTAX_PREFIX = "Usage: ";
    private static final String DEFAULT_ARG_NAME = "arg";
    public static final String OPTION_PREFIX = "-";
    public static final String LONG_OPTION_PREFIX = "--";
    private static final String LONG_OPTION_SEPARATOR = " ";
    private static final String ARG_BRACKET_OPEN = "<";
    private static final String ARG_BRACKET_CLOSE = ">";
    private static final String OPTIONAL_BRACKET_OPEN = "[";
    private static final String OPTIONAL_BRACKET_CLOSE = "]";
    private int width = 76;
    private int maxLeftWidth = 15;
    private int leftPad = 3;
    private int descPad = 3;
    private String syntaxPrefix = "Usage: ";
    private String argName = "arg";
    private Comparator<Option> optionComparator;
    private final Console console;

    public HelpFormatter(Console console) {
        this.console = console;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getMaxLeftWidth() {
        return this.maxLeftWidth;
    }

    public void setMaxLeftWidth(int maxLeftWidth) {
        this.maxLeftWidth = maxLeftWidth;
    }

    public int getLeftPad() {
        return this.leftPad;
    }

    public void setLeftPad(int leftPad) {
        this.leftPad = leftPad;
    }

    public int getDescPad() {
        return this.descPad;
    }

    public void setDescPad(int descPad) {
        this.descPad = descPad;
    }

    public String getSyntaxPrefix() {
        return this.syntaxPrefix;
    }

    public void setSyntaxPrefix(String prefix) {
        this.syntaxPrefix = prefix;
    }

    public String getArgName() {
        return this.argName;
    }

    public void setArgName(String name) {
        this.argName = name;
    }

    public Comparator<Option> getOptionComparator() {
        return this.optionComparator;
    }

    public void setOptionComparator(Comparator<Option> comparator) {
        this.optionComparator = comparator;
    }

    public void printHelp(Command command) {
        if (command.getDescriptor().getUsage() != null) {
            this.printUsage(command.getDescriptor().getUsage());
        } else {
            this.printUsage(command);
        }
        int leftWidth = this.printOptions(command.getOptions());
        this.printArguments(command.getArgumentsList(), leftWidth);
    }

    public void printUsage(String cmdLineSyntax) {
        int nextLineTabStop = this.getSyntaxPrefix().length() + cmdLineSyntax.indexOf(32) + 1;
        this.printWrapped(nextLineTabStop, this.getSyntaxPrefix() + cmdLineSyntax);
    }

    public void printUsage(Command command) {
        String commandName = command.getDescriptor().getName();
        StringBuilder sb = new StringBuilder(this.getSyntaxPrefix()).append(commandName).append(LONG_OPTION_SEPARATOR);
        ArrayList<OptionGroup> processedGroups = new ArrayList<OptionGroup>();
        Collection<Option> optList = command.getOptions().getAllOptions();
        if (optList.size() > 1 && this.getOptionComparator() != null) {
            ArrayList<Option> optList2 = new ArrayList<Option>(optList);
            optList2.sort(this.getOptionComparator());
            optList = optList2;
        }
        Iterator<Option> it = optList.iterator();
        while (it.hasNext()) {
            Option option = it.next();
            OptionGroup group = command.getOptions().getOptionGroup(option);
            if (group != null) {
                if (!processedGroups.contains(group)) {
                    processedGroups.add(group);
                    this.appendOptionGroup(sb, group);
                }
            } else {
                this.appendOption(sb, option, option.isRequired());
            }
            if (!it.hasNext()) continue;
            sb.append(LONG_OPTION_SEPARATOR);
        }
        for (Arguments arguments : command.getArgumentsList()) {
            sb.append(LONG_OPTION_SEPARATOR);
            this.appendArguments(sb, arguments);
        }
        this.printWrapped(this.getSyntaxPrefix().length() + commandName.length() + 1, sb.toString());
    }

    private void appendOptionGroup(StringBuilder sb, OptionGroup group) {
        ArrayList<Option> optList;
        if (!group.isRequired()) {
            sb.append(OPTIONAL_BRACKET_OPEN);
        }
        if ((optList = new ArrayList<Option>(group.getOptions())).size() > 1 && this.getOptionComparator() != null) {
            optList.sort(this.getOptionComparator());
        }
        Iterator it = optList.iterator();
        while (it.hasNext()) {
            this.appendOption(sb, (Option)it.next(), true);
            if (!it.hasNext()) continue;
            sb.append(" | ");
        }
        if (!group.isRequired()) {
            sb.append(OPTIONAL_BRACKET_CLOSE);
        }
    }

    private void appendOption(StringBuilder sb, Option option, boolean required) {
        if (!required) {
            sb.append(OPTIONAL_BRACKET_OPEN);
        }
        if (option.getName() != null) {
            sb.append(OPTION_PREFIX).append(option.getName());
        } else {
            sb.append(LONG_OPTION_PREFIX).append(option.getLongName());
        }
        if (option.hasValue() && (option.getValueName() == null || !option.getValueName().isEmpty())) {
            sb.append(option.isWithEqualSign() ? Character.valueOf('=') : LONG_OPTION_SEPARATOR);
            sb.append(ARG_BRACKET_OPEN).append(option.getValueName() != null ? option.getValueName() : this.getArgName()).append(ARG_BRACKET_CLOSE);
        }
        if (!required) {
            sb.append(OPTIONAL_BRACKET_CLOSE);
        }
    }

    private void appendArguments(StringBuilder sb, Arguments arguments) {
        if (!arguments.isRequired()) {
            sb.append(OPTIONAL_BRACKET_OPEN);
        }
        sb.append(ARG_BRACKET_OPEN);
        Iterator it = arguments.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (name.startsWith(ARG_BRACKET_OPEN) && name.endsWith(ARG_BRACKET_CLOSE)) {
                name = name.substring(1, name.length() - 1);
            }
            sb.append(name);
            if (!it.hasNext()) continue;
            sb.append("|");
        }
        sb.append(ARG_BRACKET_CLOSE);
        if (!arguments.isRequired()) {
            sb.append(OPTIONAL_BRACKET_CLOSE);
        }
    }

    public int printOptions(Options options) {
        Collection<Option> optList = options.getAllOptions();
        StringBuilder sb = new StringBuilder();
        int leftWidth = 0;
        if (!options.isEmpty()) {
            leftWidth = this.renderOptions(sb, optList);
            if (sb.length() > 0) {
                if (StringUtils.hasLength((String)options.getTitle())) {
                    this.console.writeLine(options.getTitle());
                }
                this.console.writeLine(sb.toString());
            }
        }
        return leftWidth;
    }

    public void printArguments(List<Arguments> argumentsList, int leftWidth) {
        StringBuilder sb = new StringBuilder();
        for (Arguments arguments : argumentsList) {
            this.renderArguments(sb, arguments, leftWidth);
            if (sb.length() <= 0) continue;
            if (StringUtils.hasLength((String)arguments.getTitle())) {
                this.console.writeLine(arguments.getTitle());
            }
            this.console.write(sb.toString());
            sb.setLength(0);
        }
    }

    public void printWrapped(String text) {
        this.printWrapped(0, text);
    }

    private void printWrapped(int nextLineTabStop, String text) {
        StringBuilder sb = new StringBuilder(text.length());
        this.renderWrappedTextBlock(sb, nextLineTabStop, text);
        this.console.writeLine(sb.toString());
    }

    private int renderOptions(StringBuilder sb, Collection<Option> options) {
        String lpad = OptionUtils.createPadding(this.getLeftPad());
        String dpad = OptionUtils.createPadding(this.getDescPad());
        int leftWidth = 0;
        ArrayList<StringBuilder> lineBufList = new ArrayList<StringBuilder>();
        Collection<Option> optList = options;
        if (optList.size() > 1 && this.getOptionComparator() != null) {
            ArrayList<Option> optList2 = new ArrayList<Option>(optList);
            optList2.sort(this.getOptionComparator());
            optList = optList2;
        }
        for (Option option : optList) {
            StringBuilder lineBuf = new StringBuilder();
            if (option.getName() == null) {
                lineBuf.append(lpad).append(LONG_OPTION_PREFIX).append(option.getLongName());
            } else {
                lineBuf.append(lpad).append(OPTION_PREFIX).append(option.getName());
                if (option.hasLongName()) {
                    lineBuf.append(", ").append(LONG_OPTION_PREFIX).append(option.getLongName());
                }
            }
            if (option.hasValue()) {
                String argName = option.getValueName();
                if (argName != null && argName.isEmpty()) {
                    lineBuf.append(' ');
                } else {
                    lineBuf.append(option.isWithEqualSign() ? Character.valueOf('=') : LONG_OPTION_SEPARATOR);
                    lineBuf.append(ARG_BRACKET_OPEN).append(argName != null ? argName : this.getArgName()).append(ARG_BRACKET_CLOSE);
                }
            }
            lineBufList.add(lineBuf);
            leftWidth = lineBuf.length() > leftWidth ? lineBuf.length() : leftWidth;
        }
        if (leftWidth > this.getMaxLeftWidth()) {
            leftWidth = this.getMaxLeftWidth();
        }
        int x = 0;
        Iterator<Option> it = optList.iterator();
        while (it.hasNext()) {
            StringBuilder lineBuf;
            Option option = it.next();
            if ((lineBuf = (StringBuilder)lineBufList.get(x++)).length() <= leftWidth) {
                if (lineBuf.length() < leftWidth) {
                    lineBuf.append(OptionUtils.createPadding(leftWidth - lineBuf.length()));
                }
                lineBuf.append(dpad);
                if (option.getDescription() != null) {
                    lineBuf.append(option.getDescription());
                }
                HelpFormatter.renderWrappedText(sb, this.getWidth(), leftWidth + this.getDescPad(), lineBuf.toString());
            } else {
                sb.append((CharSequence)lineBuf).append(NEW_LINE);
                if (option.getDescription() != null) {
                    String line = OptionUtils.createPadding(leftWidth + this.getDescPad()) + option.getDescription();
                    HelpFormatter.renderWrappedText(sb, this.getWidth(), leftWidth + this.getDescPad(), line);
                }
            }
            if (!it.hasNext()) continue;
            sb.append(NEW_LINE);
        }
        return leftWidth;
    }

    private void renderArguments(StringBuilder sb, Arguments arguments, int leftWidth) {
        String lpad = OptionUtils.createPadding(this.getLeftPad());
        String dpad = OptionUtils.createPadding(this.getDescPad());
        int max = leftWidth;
        for (String string : arguments.keySet()) {
            if (this.getLeftPad() + string.length() <= max) continue;
            max = this.getLeftPad() + string.length();
        }
        if (max > this.getMaxLeftWidth()) {
            max = this.getMaxLeftWidth();
        }
        for (Map.Entry entry : arguments.entrySet()) {
            String arg = (String)entry.getKey();
            String desc = (String)entry.getValue();
            StringBuilder buf = new StringBuilder(lpad).append(arg);
            if (buf.length() <= max) {
                if (buf.length() < max) {
                    buf.append(OptionUtils.createPadding(max - buf.length()));
                }
                buf.append(dpad);
                if (desc != null) {
                    buf.append(desc);
                }
                HelpFormatter.renderWrappedText(sb, this.getWidth(), max + this.getDescPad(), buf.toString());
            } else {
                sb.append((CharSequence)buf).append(NEW_LINE);
                if (desc != null) {
                    String line = OptionUtils.createPadding(max + this.getDescPad()) + desc;
                    HelpFormatter.renderWrappedText(sb, this.getWidth(), max + this.getDescPad(), line);
                }
            }
            sb.append(NEW_LINE);
        }
    }

    private void renderWrappedTextBlock(StringBuilder sb, int nextLineTabStop, String text) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(text));
            boolean firstLine = true;
            while ((line = in.readLine()) != null) {
                if (!firstLine) {
                    sb.append(NEW_LINE);
                } else {
                    firstLine = false;
                }
                HelpFormatter.renderWrappedText(sb, this.getWidth(), nextLineTabStop, line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void renderWrappedText(StringBuilder sb, int width, int nextLineTabStop, String text) {
        int pos = OptionUtils.findWrapPos(text, width, 0);
        if (pos == -1) {
            sb.append(OptionUtils.rtrim(text));
            return;
        }
        sb.append(OptionUtils.rtrim(text.substring(0, pos))).append(NEW_LINE);
        if (nextLineTabStop >= width) {
            nextLineTabStop = 1;
        }
        String padding = OptionUtils.createPadding(nextLineTabStop);
        String line = text;
        while (true) {
            if ((pos = OptionUtils.findWrapPos(line = padding + line.substring(pos).trim(), width, 0)) == -1) {
                sb.append(line);
                return;
            }
            if (line.length() > width && pos == nextLineTabStop - 1) {
                pos = width;
            }
            sb.append(OptionUtils.rtrim(line.substring(0, pos))).append(NEW_LINE);
        }
    }
}

