/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.shell.command.option.OptionParserException;
import java.util.Iterator;
import java.util.List;

public class MissingOptionException
extends OptionParserException {
    private static final long serialVersionUID = -3648528884089184961L;
    private List<?> missingOptions;

    public MissingOptionException(String message) {
        super(message);
    }

    public MissingOptionException(List<?> missingOptions) {
        this(MissingOptionException.createMessage(missingOptions));
        this.missingOptions = missingOptions;
    }

    public List<?> getMissingOptions() {
        return this.missingOptions;
    }

    private static String createMessage(List<?> missingOptions) {
        StringBuilder buf = new StringBuilder("Missing required option");
        buf.append(missingOptions.size() == 1 ? "" : "s");
        buf.append(": ");
        Iterator<?> it = missingOptions.iterator();
        while (it.hasNext()) {
            buf.append(it.next());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

